-- player setup
minetest.register_on_joinplayer(function (player)
  if player == nil then return end
  local name = player:get_player_name()
  player:set_properties({
    hp_max = 25
  })

  player:get_inventory():set_width("main", 8)
  player:get_inventory():set_size("main", 8 * 4)
  player:hud_set_hotbar_itemcount(8)

  -- creative mode privs
  if minetest.is_creative_enabled(name) then
    minetest.set_player_privs(name, PyuTest.util.tableconcat({
      fly = true,
      fast = true,
      noclip = true,
      settime = true,
      creative = true,
      teleport = true,
    }, minetest.get_player_privs(name)))
  end
end)

-- player physics
local function set_player_speed(player, speed)
  player:set_physics_override({
    speed = speed,
  })
end

minetest.register_globalstep(function(dtime)
  local players = minetest.get_connected_players()
  for p=1, #players do
    local ctrl = players[p]:get_player_control()
    if ctrl.aux1 then
      set_player_speed(players[p], 1.60)
    else
      set_player_speed(players[p], 1)
    end
  end
end)

-- player hand
minetest.register_item(":", {
  type = "none",
  wield_image = "pyutest-hand.png"
})

if minetest.is_creative_enabled("")  then
  minetest.override_item("", {
    range = 9,
    tool_capabilities = PyuTest.tool_caps({
      uses = 0,
      time = 0.35,

      groupcaps = {
        crumbly = {},
        choppy = {},
        cracky = {},
        snappy = {},
        explody = {},
        oddly_breakable_by_hand = {}
      },

      attack_uses = 0,
      damage_groups = {fleshy = 10000}
    })
  })
else
  minetest.override_item("", {
    range = 5,
    tool_capabilities = PyuTest.tool_caps({
      uses = 0,
      attck_uses = 0,
      damage_groups = {fleshy = 2},

      groupcaps = {
        oddly_breakable_by_hand = {
          times = {
            [PyuTest.BLOCK_FAST] = 0.35,
            [PyuTest.BLOCK_NORMAL] = 0.50,
            [PyuTest.BLOCK_SLOW] = 0.65,
          }
        },
        snappy = {
          times = {
            [PyuTest.BLOCK_FAST] = 0.55,
            [PyuTest.BLOCK_NORMAL] = 0.70,
            [PyuTest.BLOCK_SLOW] = 0.70
          }
        },
        crumbly = {
          times = {
            [PyuTest.BLOCK_FAST] = 0.75,
            [PyuTest.BLOCK_NORMAL] = 0.80,
            [PyuTest.BLOCK_SLOW] = 0.90
          }
        },
        choppy = {
          times = {
            [PyuTest.BLOCK_FAST] = 1.2,
            [PyuTest.BLOCK_NORMAL] = 2.3,
            [PyuTest.BLOCK_SLOW] = 2.9,
          }
        },
        cracky = {
          times = {
            [PyuTest.BLOCK_FAST] = 6,
            [PyuTest.BLOCK_NORMAL] = 10,
            [PyuTest.BLOCK_SLOW] = 45,
          }
        }
      }
    })
  })
end

-- unlimited blocks in creative mode
minetest.register_on_placenode(function(_, _, placer)
  if placer and placer:is_player() then
    return minetest.is_creative_enabled(placer:get_player_name())
  end
end)

-- player death message
minetest.register_on_dieplayer(function(player, reason)
  local playername = player:get_player_name()

  if reason.object ~= nil then
    local le = reason.object:get_luaentity()

    if le == nil then
      minetest.chat_send_all(string.format("%s was slain by %s",
      playername, reason.object:get_player_name()))
    else
      local split = string.split(le.name, ":")
      local name = split[#split]
      name = name:gsub("_", " ")
      name = string.upper(name:sub(1, 1))..name:sub(2, name:len())
      minetest.chat_send_all(string.format("%s was slain by %s", playername, name))
    end
  end
end)
