PyuTest.LavaWorld = PyuTest.register_world({
  name = "lava_world",
  y_max = -3002,
  y_min = -4002
})
PyuTest.LavaWorld:create_token("pyutest_worlds:lava_world_token", "Lava World", "#511e1e", "pyutest_tools:ash")

local lava_cavern = PyuTest.LavaWorld:register_biome({
  name = "lava_cavern",
  node_stone = "pyutest_blocks:molten_rock_block",
  heat_point = 100,
  humidity_point = 0,
})

PyuTest.LavaWorld:register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:magma",
  wherein = "pyutest_blocks:molten_rock_block",
  clust_scarcity = 4.5 * 4.5 * 4.5,
  clust_num_ores = 6,
  clust_size = 5,
  biomes = {lava_cavern},
  noise_params = PyuTest.SPECIALSTONE_NOISE_PARAMS
})

PyuTest.LavaWorld:register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:lava_source",
  wherein = "pyutest_blocks:molten_rock_block",
  clust_scarcity = 7.5 * 7.5 * 7.5,
  clust_num_ores = 1,
  clust_size = 2,
  biomes = {lava_cavern},
  noise_params = PyuTest.SPECIALSTONE_NOISE_PARAMS
})

PyuTest.LavaWorld:register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:lava_source",
  wherein = "pyutest_blocks:molten_rock_block",
  clust_scarcity = 14.5 * 14.5 * 14.5,
  clust_num_ores = 4,
  clust_size = 6,
  biomes = {lava_cavern},
  noise_params = PyuTest.SPECIALSTONE_NOISE_PARAMS
})

-- PyuTest.LavaWorld:register_decoration({
--   deco_type = "simple",
--   sidelen = 16,
--   fill_ratio = 0.00063,
--   decoration = {"pyutest_blocks:lava_source"},
--   place_on = {"pyutest_blocks:molten_rock_block", "pyutest_blocks:magma"},
--   biomes = {lava_cavern},
--   flags = "all_ceilings"
-- })
