local windball_hit_player = function (self, player)
  player:punch(self.object, nil, {
    damage_groups = {fleshy = 3}
  }, nil)

  math.randomseed(os.time())
  player:add_velocity({
    x = 0,
    z = 0,
    y = math.random(18, 25)
  })
end

mobs:register_arrow("pyutest_mobs:arrow_windball", {
  visual = "sprite",
  visual_size = {x = 1, y = 1},
  textures = {"pyutest-windball.png"},
  hit_player = windball_hit_player,
  hit_mob = windball_hit_player,
  velocity = 9,
  collisionbox = {
    -1.5, -1.5, -1.5, 1.5, 1.5, 1.5
  }
})

mobs:register_mob("pyutest_mobs:wind_warrior", {
  type = "monster",
  hp_max = 120,
  hp_min = 120,
  walk_velocity = 1,
  run_velocity = 4,
  armor = 100,
  passive = false,
  walk_chance = 1,
  stand_chance = 2,
  damage = 9,
  attack_chance = 1,
  attack_type = "dogshoot",
  arrow = "pyutest_mobs:arrow_windball",
  shoot_interval = 0.75,
  shoot_offset = 2,
  homing = true,
  pathfinding = 1,
  visual = "upright_sprite",
  visual_size = {x = 1, y = 2},
  collisionbox = PyuTest.HUMAN_LIKE_CBOX,
  physical = true,
  blood_amount = PyuTest.ENTITY_BLOOD_AMOUNT,
  view_range = 35,
  reach = 2,
  jump = 1,
  group_attack = false,
  makes_footstep_sound = true,
  dogshoot_switch = 1,
  dogshoot_count_max = 3,
  dogshoot_count2_max = 6,

  textures = {
    "pyutest-wind-warrior.png", "pyutest-wind-warrior_back.png"
  },

  drops = {
    {
      name = "pyutest_magic:magic_shards",
      min = 4,
      max = 7,
      chance = 1
    },

    {
      name = "pyutest_magic:windball",
      min = 2,
      max = 4,
      chance = 1
    }
  }
})
PyuTest.create_boss_egg("pyutest_mobs:wind_warrior", "Wind Warrior Spawn Egg",
"pyutest-egg.png^[multiply:white", 0, nil,
-- just a place holder until more wind-related items come.
"pyutest_core:iron_ingot")
