PyuTest.make_liquid = function(name, desc, groups, texture, speed, extra_conf)
  local function make_liquid_flags(liquidtype)
    local drawtype = ""

    if liquidtype == "source" then
      drawtype = "liquid"
    elseif liquidtype == "flowing" then
      drawtype = "flowingliquid"
    end

    local t = PyuTest.util.tableconcat({
      drawtype = drawtype,
      waving = 3,
      walkable = false,
      pointable = false,
      buildable_to = true,
      is_ground_content = false,
      use_texture_alpha = "blend",
      paramtype = "light",
      drop = "",
      drowning = 3,
      liquidtype = liquidtype,
      liquid_renewable = true,
      liquid_viscosity = speed or 1,
      liquid_alternative_flowing = name .. "_flowing",
      liquid_alternative_source = name .. "_source",
      paramtype2 = liquidtype == "flowing" and "flowingliquid" or nil,
      special_tiles = liquidtype == "flowing" and {
        {
          name = texture,
          backface_culling = false
        },
        {
          name = texture,
          backface_culling = true
        }
      } or nil
    }, extra_conf or {})
    return t
  end

  local g = groups or {}
  g["liquid"] = 1

  PyuTest.make_node(name .. "_source", desc .. " Source", g, { texture }, make_liquid_flags("source"))
  PyuTest.make_node(name .. "_flowing", "Flowing " .. desc, g, { texture }, make_liquid_flags("flowing"))
end

PyuTest.make_liquid("pyutest_blocks:water", "Water", {
  water = 1,
  freezable = 1,
  heatable = 1
}, "pyutest-water.png", 1, {
  post_effect_color = { a = 60, r = 24.7, g = 46.3, b = 89.4 },
  paramtype2 = "color",
})

PyuTest.make_liquid("pyutest_blocks:lava", "Lava", {
  lava = 1,
  coolable = 1
}, "pyutest-lava.png", 5, {
  damage_per_second = 4,
  light_source = 8
})
PyuTest.make_liquid("pyutest_blocks:oil", "Oil", {}, "pyutest-oil.png", 3)
PyuTest.make_liquid("pyutest_blocks:liquid_acid", "Acid", {}, "pyutest-acid.png", 7, {
  damage_per_second = 4
})
