PyuTest.make_leaves = function(id, desc, tiles)
  PyuTest.make_building_blocks(id.."_leaves", desc .. " Leaves", tiles, nil, {
    acid_vulnerable = 1,
    flammable = 1,
    snappy = PyuTest.BLOCK_FAST
  }, {
    is_ground_content = false
  })

  local leaves_id = id .. "_leaves_block"
  minetest.override_item(leaves_id, {
    drop = {
      max_items = 1,
      items = {
        {
          rarity = 2.5,
          items = { "pyutest_tools:apple 1" }
        },

        {
          items = { leaves_id }
        }
      }
    }
  })
end

PyuTest.make_leaves("pyutest_leaves:oak", "Oak", { "pyutest-leaves.png" })
PyuTest.make_leaves("pyutest_leaves:snowy", "Snowy", { "pyutest-snowy-leaves.png" })
PyuTest.make_leaves("pyutest_leaves:cherry", "Cherry", { "pyutest-cherry-leaves.png" })
PyuTest.make_leaves("pyutest_leaves:dark", "Dark", { "pyutest-dark-leaves.png" })
PyuTest.make_leaves("pyutest_leaves:aspen", "Aspen", { "pyutest-aspen-leaves.png" })
PyuTest.make_leaves("pyutest_leaves:red_aspen", "Red Aspen", { "pyutest-red-aspen-leaves.png" })
