PyuTest.make_grass = function (name, desc, groups, color, ttex, stex, dtex)
  local _ttex = {name = ttex or "pyutest-grass-top.png", color = color}
  local _stex = {name = stex or "pyutest-grass-side.png", color = color}
  local _dtex = {_ttex, dtex or "pyutest-dirt.png"}

  PyuTest.make_building_blocks(name, desc, _dtex, nil, PyuTest.util.tableconcat(groups or {}, {
    ground = 1,
    grass = 1,
  }), {
    overlay_tiles = {"", "", _stex}
  })

  PyuTest.make_flower(name.."_plant", desc .. " Plant", "pyutest-grass-plant.png", nil, false, nil, {
    color = color
  })
end

PyuTest.make_grass("pyutest_grass:grass", "Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1
}, "#6baf4a")

PyuTest.make_grass("pyutest_grass:dark_grass", "Dark Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1
}, "#388b4a")

PyuTest.make_grass("pyutest_grass:swampy_grass", "Swampy Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1,
  sugarcane_spawn_on = 1
}, "#48592a")

PyuTest.make_grass("pyutest_grass:savanna_grass", "Savanna Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1,
  sugarcane_spawn_on = 1,
}, "#9faf4a")

PyuTest.make_grass("pyutest_grass:aspen_grass", "Aspen Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1,
}, "#ad9d4b")

PyuTest.make_grass("pyutest_grass:jungle_grass", "Jungle Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1,
}, "#3b562d")

PyuTest.make_grass("pyutest_grass:snowy_grass", "Snowy Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1,
}, "#f2f6fb")
