PyuTest.SPECIALSTONE_NOISE_PARAMS = {
  offset = 0,
  scale = 1,
  spread = {x = 250, y = 250, z = 250},
  seed = 1536,
  octaves = 3,
  persist = 0.4,
  lacunarity = 2,
  flags = "defaults"
}

minetest.register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:granite_block",
  wherein = "pyutest_blocks:stone_block",
  clust_scarcity = 9 * 9 * 9,
  clust_num_ores = 35,
  clust_size = 5,
  y_max = PyuTest.OVERWORLD_SURFACE_BOTTOM - 1,
  y_min = PyuTest.OVERWORLD_BOTTOM,
  noise_params = PyuTest.SPECIALSTONE_NOISE_PARAMS
})

minetest.register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:andesite_block",
  wherein = "pyutest_blocks:stone_block",
  clust_scarcity = 9 * 9 * 9,
  clust_num_ores = 35,
  clust_size = 5,
  y_max = PyuTest.OVERWORLD_SURFACE_BOTTOM - 1,
  y_min = PyuTest.OVERWORLD_BOTTOM,
  noise_params = PyuTest.SPECIALSTONE_NOISE_PARAMS
})

minetest.register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:clay_block",
  wherein = "pyutest_blocks:gravel_block",
  clust_scarcity = 7 * 7 * 7,
  clust_num_ores = 35,
  clust_size = 5,
  y_max = PyuTest.OVERWORLD_SURFACE_BOTTOM - 1,
  y_min = PyuTest.DEAP_OCEAN_MIN,
  noise_params = PyuTest.SPECIALSTONE_NOISE_PARAMS
})

PyuTest.ORE_STONES = {
  "pyutest_blocks:stone_block",
  "pyutest_blocks:granite_block",
  "pyutest_blocks:andesite_block",
}

PyuTest.registered_ores = {}

PyuTest.make_ore_and_item = function(id, desc, item_id_suffix, item_description_suffix, options)
  local default_options = {
    scarcity = 5 * 5 * 5,
    y_max = PyuTest.WORLD_TOP,
    y_min = PyuTest.OVERWORLD_BOTTOM,
    wherein = {},

    ore_strength = PyuTest.BLOCK_NORMAL,
    ore_conf = {},
    ore_groups = {},
    ore_drop = nil,
    ore_drop_count = 1,
    ore_sounds = nil,
    ore_stone = {"pyutest-stone.png"},
    ore_color = nil,

    item_conf = {},
    item_groups = {},
    item_texture = nil,

    make_raw = false,
    raw_conf = {},
    raw_groups = {},
    raw_texture = {},

    block_conf = {},
    block_color = nil,
    block_tiles = {},
    block_groups = {}
  }
  local conf = {}

  for k, v in pairs(options) do
    conf[k] = v
  end

  for k, v in pairs(default_options) do
    if conf[k] == nil then
      conf[k] = v
    end
  end


  local oid = id.."_ore"
  local iid = id.."_"..item_id_suffix
  local rid = conf.make_raw and id.."_raw" or nil

  minetest.register_node(oid, PyuTest.util.tableconcat({
    description = Translate(desc .. " Ore"),
    groups = PyuTest.util.tableconcat({
      cracky = conf.ore_strength,
      mineral = 1,
    }, conf.ore_groups),
    -- light_source = 2.2,
    drop = conf.ore_drop or (conf.make_raw and rid or iid) .. " " .. tostring(conf.ore_drop_count or 1),
    sounds = PyuTest.make_node_sounds(conf.ore_sounds),
    tiles = conf.ore_stone,
    overlay_tiles = {{name = "pyutest-ore-overlay.png", color = conf.ore_color}}
  }, conf.ore_conf))

  minetest.register_craftitem(iid, PyuTest.util.tableconcat({
    description = Translate(desc .. " " .. item_description_suffix),
    groups = PyuTest.util.tableconcat({
      mineral = 1
    }, conf.item_groups),
    wield_image = conf.item_texture,
    inventory_image = conf.item_texture
  }, conf.item_conf))

  if conf.make_raw then
    minetest.register_craftitem(rid, PyuTest.util.tableconcat({
      description = Translate("Raw " .. desc),
      groups = PyuTest.util.tableconcat({
        mineral = 1,
        raw_mineral = 1
      }, conf.raw_groups),
      wield_image = conf.raw_texture,
      inventory_image = conf.raw_texture
    }, conf.raw_conf))

    minetest.register_craft({
      type = "cooking",
      output = iid,
      recipe = rid
    })
  end

  minetest.register_ore({
    ore_type = "scatter",
    ore = oid,
    wherein = conf.wherein,
    clust_scarcity = conf.scarcity,
    clust_num_ores = 4,
    clust_size = 3,
    y_max = conf.y_max,
    y_min = conf.y_min,
  })

  minetest.register_ore({
    ore_type = "scatter",
    ore = oid,
    wherein = conf.wherein,
    clust_scarcity = conf.scarcity * 2.2,
    clust_num_ores = 9,
    clust_size = 3,
    y_max = conf.y_max,
    y_min = conf.y_min,
  })

  minetest.register_ore({
    ore_type = "scatter",
    ore = oid,
    wherein = conf.wherein,
    clust_scarcity = conf.scarcity * 3,
    clust_num_ores = 18,
    clust_size = 6,
    y_max = conf.y_max,
    y_min = conf.y_min,
  })

  PyuTest.make_building_blocks(id, desc, conf.block_tiles, conf.block_color, PyuTest.util.tableconcat({
    cracky = conf.ore_strength
  }, conf.block_groups), conf.block_conf)

  local bid = id.."_block"
  minetest.register_craft({
    output = bid,
    recipe = {
      {iid, iid},
      {iid, iid}
    }
  })

  minetest.register_craft({
    output = iid .. " 4",
    recipe = {
      bid
    },
    type = "shapeless"
  })
end

-- "Primary" Ores
PyuTest.make_ore_and_item("pyutest_ores:coal", "Coal", "lump", "Lump", {
  scarcity = 8 * 8 * 8,
  y_max = 48,
  wherein = PyuTest.ORE_STONES,

  ore_strength = PyuTest.BLOCK_NORMAL,
  ore_drop_count = 2,
  ore_color = {r = 32, g = 32, b = 32},

  item_texture = "pyutest-lump.png",
  item_conf = {
    color = {r = 32, g = 32, b = 32}
  },
  item_groups = {
    fuel = 1
  },

  block_tiles = {"pyutest-metal.png"},
  block_color = {r = 32, g = 32, b = 32}
})

PyuTest.make_ore_and_item("pyutest_ores:iron", "Iron", "ingot", "Ingot", {
  scarcity = 11 * 11 * 11,
  y_max = 18,
  wherein = PyuTest.ORE_STONES,

  ore_strength = PyuTest.BLOCK_NORMAL,

  item_texture = "pyutest-ingot.png",

  make_raw = true,
  raw_texture = "pyutest-lump.png",

  block_tiles = {"pyutest-metal.png"}
})

PyuTest.make_ore_and_item("pyutest_ores:zinc", "Zinc", "ingot", "Ingot", {
  scarcity = 11 * 11 * 11,
  y_max = 18,
  wherein = PyuTest.ORE_STONES,

  ore_strength = PyuTest.BLOCK_NORMAL,
  ore_color = "#bed3d4",

  item_texture = "pyutest-ingot.png",
  item_conf = {
    color = "#bed3d4"
  },

  make_raw = true,
  raw_texture = "pyutest-lump.png",
  raw_conf = {
    color = "#bed3d4"
  },

  block_tiles = {"pyutest-metal.png"},
  block_color = "#bed3d4"
})

PyuTest.make_ore_and_item("pyutest_ores:copper", "Copper", "ingot", "Ingot", {
  scarcity = 11 * 11 * 11,
  y_max = 18,
  wherein = PyuTest.ORE_STONES,

  ore_strength = PyuTest.BLOCK_NORMAL,
  ore_color = "darkgoldenrod",

  item_texture = "pyutest-ingot.png",
  item_conf = {
    color = "darkgoldenrod",
  },

  make_raw = true,
  raw_texture = "pyutest-lump.png",
  raw_conf = {
    color = "darkgoldenrod"
  },

  block_tiles = {"pyutest-metal.png"},
  block_color = "darkgoldenrod"
})

PyuTest.make_ore_and_item("pyutest_ores:gold", "Gold", "ingot", "Ingot", {
  scarcity = 15.5 * 15.5 * 15.5,
  y_max = -35,
  wherein = PyuTest.ORE_STONES,

  ore_strength = PyuTest.BLOCK_NORMAL,
  ore_color = "gold",

  item_texture = "pyutest-ingot.png",
  item_conf = {
    color = "gold"
  },

  make_raw = true,
  raw_texture = "pyutest-lump.png",
  raw_conf = {
    color = "gold"
  },

  block_tiles = {"pyutest-metal.png"},
  block_color = "gold"
})

PyuTest.make_ore_and_item("pyutest_ores:diamond", "Diamond", "shard", "Shard", {
  scarcity = 16.7 * 16.7 * 16.7,
  y_max = -50,
  wherein = PyuTest.ORE_STONES,

  ore_strength = PyuTest.BLOCK_NORMAL,
  ore_color = "cyan",

  item_texture = "pyutest-shard.png",
  item_conf = {
    color = "cyan"
  },

  block_tiles = {"pyutest-metal.png"},
  block_color = "cyan"
})

PyuTest.make_ore_and_item("pyutest_ores:emerald", "Emerald", "shard", "Shard", {
  scarcity = 18.3 * 18.3 * 18.3,
  y_max = -50,
  wherein = PyuTest.ORE_STONES,

  ore_strength = PyuTest.BLOCK_NORMAL,
  ore_color = "seagreen",

  item_texture = "pyutest-shard.png",
  item_conf = {
    color = "seagreen"
  },

  block_tiles = {"pyutest-metal.png"},
  block_color = "seagreen"
})

-- "Secondary" Ores

PyuTest.make_ore_and_item("pyutest_ores:tin", "Tin", "ingot", "Ingot", {
  scarcity = 11 * 11 * 11,
  y_max = 18,
  wherein = PyuTest.ORE_STONES,

  ore_strength = PyuTest.BLOCK_NORMAL,
  ore_color = "#686569",

  item_texture = "pyutest-ingot.png",
  item_conf = {
    color = "#686569"
  },

  make_raw = true,
  raw_texture = "pyutest-lump.png",
  raw_conf = {
    color = "#686569"
  },

  block_tiles = {"pyutest-metal.png"},
  block_color = "#686569"
})
