local delay_multipliers = {
  100, -- Default, 0.1 seconds
  200, -- 0.2 seconds
  400, -- 0.4 seconds
  800, -- 0.8 seconds
}

local function index_name(n)
  if n == 1 or n == nil then
    return "pyutest_electricity:zinc_wire"
  else
    return string.format("pyutest_electricity:zinc_wire_%d", n)
  end
end

for i, v in ipairs(delay_multipliers) do
  PyuTest.make_wire(index_name(i), "Zinc Wire", {
    snappy = PyuTest.BLOCK_NORMAL,
    not_in_creative_inventory = i ~= 1 and 1 or nil
  }, "#bed3d4", {
    drop = index_name(),
    on_rightclick = function (pos, node, clicker)
      local ni = v

      if i == #delay_multipliers then
        ni = 1
      else
        ni = i + 1
      end

      minetest.set_node(pos, {name = index_name(ni)})
    end
  }, string.format("pyutest-wire-d%d.png", i), v)
end

minetest.register_craft({
  output = string.format("%s 4", index_name()),
  recipe = {
    "pyutest_ores:zinc_ingot"
  },
  type = "shapeless"
})
