PyuTest.registered_colored_blocks = {}
PyuTest.make_colored_blocks = function(name, desc, color)
  PyuTest.make_building_blocks(name.."_wool", desc.." Wool", {
    "pyutest-wool.png"
  }, color or "white", {
    oddly_breakable_by_hand = PyuTest.BLOCK_NORMAL,
    colored = 1
  })

  PyuTest.make_building_blocks(name.."_terracotta", desc .. " Terracotta", {
    "pyutest-terracotta.png"
  }, color or "white", {
    cracky = PyuTest.BLOCK_FAST,
    colored = 1
  })

  PyuTest.make_item(name.."_dye", desc.." Dye", {}, "pyutest-dye.png", {
    color = color or "white"
  })


  minetest.register_craft({
    output = name.."_wool_block",
    type = "shapeless",
    recipe = {
      "pyutest_wool:white_wool_block",
      name.."_dye"
    }
  })

  minetest.register_craft({
    output = name.."_terracotta_block",
    type = "shapeless",
    recipe = {
      "pyutest_wool:white_terracotta_block",
      name.."_dye"
    }
  })

  PyuTest.registered_colored_blocks[name] = {
    wool = name.."_wool",
    terracotta = name.."_terracotta",
    dye = name.."_dye"
  }
end

PyuTest.make_colored_blocks("pyutest_wool:white", "White", "white")
minetest.register_craft({
  output = "pyutest_wool:white_wool_block 4",
  recipe = {
    {"pyutest_tools:string", "pyutest_tools:string"},
    {"pyutest_tools:string", "pyutest_tools:string"}
  }
})

minetest.register_craft({
  type = "cooking",
  output = "pyutest_wool:white_terracotta_block",
  recipe = "pyutest_blocks:clay_block"
})

PyuTest.COLORS = {
  white   = {"White",   nil},
  black   = {"Black",   {r = 32, g = 32, b = 32}},
  brown   = {"Brown",   "saddlebrown"},
  red     = {"Red",     "indianred"},
  orange  = {"Orange",  "coral"},
  yellow  = {"Yellow",  "khaki"},
  green   = {"Green",   "olivedrab"},
  blue    = {"Blue",    "cornflowerblue"},
  purple  = {"Purple",  "plum"},
  pink    = {"Pink",    "pink"},
  lime    = {"Lime",    "#64C044"}
}

for k, v in pairs(PyuTest.COLORS) do
  PyuTest.make_colored_blocks("pyutest_wool:"..k, v[1], v[2])
end

PyuTest.make_dye_mixing_recipe = function(c1, c2, out)
  minetest.register_craft({
    type = "shapeless",
    output = out .. " 2",
    recipe = {
      c1, c2
    }
  })
end

PyuTest.make_dye_mixing_recipe("pyutest_wool:red_dye", "pyutest_wool:blue_dye", "pyutest_wool:purple_dye")
PyuTest.make_dye_mixing_recipe("pyutest_wool:red_dye", "pyutest_wool:yellow_dye", "pyutest_wool:orange_dye")
PyuTest.make_dye_mixing_recipe("pyutest_wool:yellow_dye", "pyutest_wool:blue_dye", "pyutest_wool:green_dye")
PyuTest.make_dye_mixing_recipe("pyutest_wool:red_dye", "pyutest_wool:white_dye", "pyutest_wool:pink_dye")
PyuTest.make_dye_mixing_recipe("pyutest_wool:red_dye", "pyutest_wool:green_dye", "pyutest_wool:brown_dye")
