local modpath = minetest.get_modpath("pyutest_mobs")
mobs.fallback_node = "pyutest_blocks:dirt_block"


dofile(modpath.."/api.lua")

dofile(modpath.."/basic.lua")
dofile(modpath.."/snowman.lua")
dofile(modpath.."/wind_warrior.lua")
dofile(modpath.."/necromancer.lua")

if not PyuTest.is_flat() then
  mobs:spawn({
    name = "pyutest_mobs:monster",
    nodes = {"group:ground"},
    interval = 4,
    chance = 1,
    active_object_count = 5,
    min_light = 0,
    max_light = minetest.LIGHT_MAX,
    max_height = PyuTest.OVERWORLD_TOP,
    min_height = PyuTest.OVERWORLD_SURFACE_BOTTOM,
    day_toggle = false
  })

  mobs:spawn({
    name = "pyutest_mobs:monster",
    nodes = {"group:ground"},
    interval = 2,
    chance = 2,
    active_object_count = 7,
    min_light = 0,
    max_light = minetest.LIGHT_MAX,
    min_height = PyuTest.OVERWORLD_SURFACE_BOTTOM - 1,
    max_height= PyuTest.OVERWORLD_BOTTOM
  })

  mobs:spawn({
    name = "pyutest_mobs:human",
    nodes = {"group:ground"},
    interval = 3,
    chance = 4,
    active_object_count = 3,
    min_light = 9,
    max_light = 15,
    min_height = PyuTest.OVERWORLD_SURFACE_BOTTOM,
    day_toggle = true,
  })

  mobs:spawn({
    name = "pyutest_mobs:mimic",
    nodes = {"group:ground"},
    interval = 3,
    chance = 18,
    active_object_count = 2,
    min_light = 0,
    max_light = 15,
    day_toggle = true,
  })

  mobs:spawn({
    name = "pyutest_mobs:firefly",
    nodes = {"group:ground", "air"},
    interval = 3,
    chance = 3,
    active_object_count = 4,
    min_light = 0,
    max_light = 9,
    day_toggle = false,
    min_height = PyuTest.OVERWORLD_SURFACE_BOTTOM
  })
end
