PyuTest.make_tool("pyutest_tools:wooden_pickaxe", "Wooden Pickaxe", {}, "pyutest-wooden-pickaxe.png", {
  stack_max = 1,
  tool_capabilities = PyuTest.tool_caps({
    uses = 69,
    attack_uses = 69 / 2,
    groupcaps = {
      cracky = {
        times = {
          [PyuTest.BLOCK_FAST] = 1.2,
          [PyuTest.BLOCK_NORMAL] = 1.4
        }
      }
    }
  })
})

PyuTest.make_tool("pyutest_tools:stone_pickaxe", "Stone Pickaxe", {}, "pyutest-stone-pickaxe.png", {
  stack_max = 1,
  tool_capabilities = PyuTest.tool_caps({
    uses = 274,
    attack_uses = 274 / 2,
    groupcaps = {
      cracky = {
        times = {
          [PyuTest.BLOCK_FAST] = 1,
          [PyuTest.BLOCK_NORMAL] = 1.2
        }
      }
    }
  })
})

PyuTest.make_tool("pyutest_tools:iron_pickaxe", "Iron Pickaxe", {}, "pyutest-iron-pickaxe.png", {
  stack_max = 1,
  tool_capabilities = PyuTest.tool_caps({
    uses = 689,
    attack_uses = 689 / 2,
    groupcaps = {
      cracky = {
        times = {
          [PyuTest.BLOCK_FAST] = 0.8,
          [PyuTest.BLOCK_NORMAL] = 1
        }
      }
    }
  })
})

PyuTest.make_tool("pyutest_tools:diamond_pickaxe", "Diamond Pickaxe", {}, "pyutest-diamond-pickaxe.png", {
  stack_max = 1,
  tool_capabilities = PyuTest.tool_caps({
    uses = 1345,
    attack_uses = 1345 / 2,
    groupcaps = {
      cracky = {
        times = {
          [PyuTest.BLOCK_FAST] = 0.2,
          [PyuTest.BLOCK_NORMAL] = 0.6,
          [PyuTest.BLOCK_SLOW] = 8
        }
      }
    }
  })
})

PyuTest.make_tool("pyutest_tools:wooden_axe", "Wooden Axe", {}, "pyutest-wooden-axe.png", {
  stack_max = 1,
  tool_capabilities = PyuTest.tool_caps({
    uses = 69,
    attack_uses = 69,
    damage_groups = {fleshy = 7},
    groupcaps = {
      choppy = {
        times = {
          [PyuTest.BLOCK_FAST] = 1.2,
          [PyuTest.BLOCK_NORMAL] = 1.4,
          [PyuTest.BLOCK_SLOW] = 1.6
        }
      }
    }
  })
})

PyuTest.make_tool("pyutest_tools:stone_axe", "Stone Axe", {}, "pyutest-stone-axe.png", {
  stack_max = 1,
  tool_capabilities = PyuTest.tool_caps({
    uses = 274,
    attack_uses = 274,
    damage_groups = {fleshy = 9},
    groupcaps = {
      choppy = {
        times = {
          [PyuTest.BLOCK_FAST] = 1,
          [PyuTest.BLOCK_NORMAL] = 1.2,
          [PyuTest.BLOCK_SLOW] = 1.4
        }
      }
    }
  })
})

PyuTest.make_tool("pyutest_tools:iron_axe", "Iron Axe", {}, "pyutest-iron-axe.png", {
  stack_max = 1,
  tool_capabilities = PyuTest.tool_caps({
    uses = 689,
    attack_uses = 689,
    damage_groups = {fleshy = 9},
    groupcaps = {
      choppy = {
        times = {
          [PyuTest.BLOCK_FAST] = 0.8,
          [PyuTest.BLOCK_NORMAL] = 1,
          [PyuTest.BLOCK_SLOW] = 1.2
        }
      }
    }
  })
})

PyuTest.make_tool("pyutest_tools:diamond_axe", "Diamond Axe", {}, "pyutest-diamond-axe.png", {
  stack_max = 1,
  tool_capabilities = PyuTest.tool_caps({
    uses = 1345,
    attack_uses = 1345,
    damage_groups = {fleshy = 9},
    groupcaps = {
      choppy = {
        times = {
          [PyuTest.BLOCK_FAST] = 0.6,
          [PyuTest.BLOCK_NORMAL] = 0.8,
          [PyuTest.BLOCK_SLOW] = 1
        }
      }
    }
  })
})


PyuTest.make_tool("pyutest_tools:shears", "Shears", {
  shears = 1
}, "pyutest-shears.png", {
  stack_max = 1,
  tool_capabilities = PyuTest.tool_caps({
    uses = 100,
    attack_uses = 50,
    groupcaps = {
      snappy = {
        times = {
          [PyuTest.BLOCK_FAST] = 0.2,
          [PyuTest.BLOCK_NORMAL] = 0.3,
          [PyuTest.BLOCK_SLOW] = 0.4
        }
      },

      wooly = {
        times = {
          [PyuTest.BLOCK_FAST] = 0.2,
          [PyuTest.BLOCK_NORMAL] = 0.3,
          [PyuTest.BLOCK_SLOW] = 0.4
        }
      }
    }
  })
})

PyuTest.make_item("pyutest_tools:bomb", "Bomb", {}, "pyutest-bomb.png", {
  stack_max = 16,
  on_use = function (_, user)
    if user == nil then
      return
    end
    local pos = user:get_pos()
    PyuTest.create_explosion(pos, 2, false, 6, user)
    local stack = user:get_wielded_item()
    stack:set_count(stack:get_count() - 1)

    user:set_wielded_item(stack)
  end
})

PyuTest.make_item("pyutest_tools:flint_and_steel", "Flint and Steel", {}, "pyutest-flint-and-steel.png", {
  stack_max = 1,
  on_place = function (itemstack, user, pointed_thing)
    if pointed_thing.type == "node" then
      minetest.set_node(pointed_thing.above, {name = "pyutest_blocks:fire"})

      minetest.sound_play({
        name = "alt_place",
        gain = 1
      }, {
        pos = user:get_pos()
      })
    end
  end
})
