PyuTest.MushroomWorld = PyuTest.register_world({
  name = "mushroom_world",
  y_max = -4000,
  y_min = -4999
})
PyuTest.MushroomWorld:create_token("pyutest_worlds:mushroom_world_token", "Mushroom World", "#ac324c", "pyutest_blocks:mushroom_block")

local mushroom_forest = PyuTest.MushroomWorld:register_biome({
  name = "mushroom_forest",
  node_stone = "pyutest_blocks:mushroom_block",
  heat_point = 36,
  humidity_point = 0
})

PyuTest.MushroomWorld:register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:mushroom_stem_block",
  wherein = "pyutest_blocks:mushroom_block",
  clust_scarcity = 9.5 * 9.5 * 9.5,
  clust_num_ores = 6,
  clust_size = 5,
  biomes = {mushroom_forest},
  noise_params = PyuTest.SPECIALSTONE_NOISE_PARAMS
})

PyuTest.MushroomWorld:register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:glowshroom_block",
  wherein = "pyutest_blocks:mushroom_block",
  clust_scarcity = 4.5 * 4.5 * 4.5,
  clust_num_ores = 6,
  clust_size = 5,
  biomes = {mushroom_forest},
  noise_params = PyuTest.SPECIALSTONE_NOISE_PARAMS
})

PyuTest.MushroomWorld:register_decoration({
  deco_type = "schematic",
  place_on = {"pyutest_blocks:mushroom_block"},
  sidelen = 16,
  fill_ratio = 0.006,
  biomes = PyuTest.MushroomWorld.biome_names,
  schematic = PyuTest.get_schem_path("HangingMushroom"),
  rotation = "random",
  flags = "place_center_x, place_center_z, all_ceilings",
  force_placement = true,
  place_offset_y = 1
})
