PyuTest.make_item("pyutest_magic:magic_shards", "Magic Shards", {}, "pyutest-magic-shards.png")

PyuTest.registered_spellbooks = {}
PyuTest.make_spellbook = function (nsname, desc, color, craftitem, action)
  if action == nil then
    action = function(_, _, _)end
  end

  PyuTest.make_item(nsname, desc, {}, "pyutest-spellbook.png", {
    stack_max = 1,
    color = color,
    on_use = function (itemstack, user, pointed_thing)
      local pos = user:get_pos()
      minetest.sound_play({name = "spellbook_action", gain = 0.75}, {pos = pos})
      action(itemstack, user, pointed_thing)
    end
  })

  minetest.register_craft({
    output = nsname,
    recipe = {
      {"", "pyutest_magic:magic_shards", ""},
      {"pyutest_magic:magic_shards", craftitem, "pyutest_magic:magic_shards"},
      {"", "pyutest_magic:magic_shards", ""}
    }
  })

  PyuTest.registered_spellbooks[nsname] = {
    color = color,
    craftitem = craftitem,
    action = action
  }
end

PyuTest.make_spellbook("pyutest_magic:explosions_spellbook", "Spellbook of Explosions", "gray", "pyutest_tools:bomb", function (itemstack, user)
  PyuTest.create_explosion(user:get_pos(), 3, false, 7, user)
end)

PyuTest.make_spellbook("pyutest_magic:fire_spellbook", "Spellbook of Fire", "crimson", "pyutest_blocks:magma", function (itemstack, user)
  local range = 2

  local function replace(pos)
    local node = minetest.get_node_or_nil(pos)
    if node == nil then return end
    if node.name ~= "air" then return end
    local pos2 = vector.new(pos.x, pos.y - 1, pos.z)
    node = minetest.get_node_or_nil(pos)
    if node == nil then return end
    if node.name ~= "air" then return end

    minetest.set_node(pos, {name = "pyutest_blocks:fire"})
  end

  for dx = -range, range do
    for dz = -range, range do
      local pos = user:get_pos()
      replace({x = pos.x + dx, y = pos.y, z = pos.z + dz})
    end
  end
end)


PyuTest.make_item("pyutest_magic:enchanted_shard", "Enchanted Shard", {}, "pyutest-shard.png", {
  color = "indigo",
})

minetest.register_craft({
  output = "pyutest_magic:enchanted_shard 2",
  recipe = {
    {"pyutest_magic:magic_shards", "pyutest_ores:diamond_shard", "pyutest_magic:magic_shards"},
    {"pyutest_ores:diamond_shard", "pyutest_magic:magic_shards", "pyutest_ores:diamond_shard"},
    {"pyutest_magic:magic_shards", "pyutest_ores:diamond_shard", "pyutest_magic:magic_shards"}
  }
})

PyuTest.make_tool("pyutest_magic:enchanted_pickaxe", "Enchanted Pickaxe", {}, "pyutest-enchanted-pickaxe.png", {
  stack_max = 1,
  tool_capabilities = PyuTest.tool_caps({
    uses = 2768,
    attack_uses = 2768 / 2,
    groupcaps = {
      cracky = {
        times = {
          [PyuTest.BLOCK_FAST] = 0.1,
          [PyuTest.BLOCK_NORMAL] = 0.4,
          [PyuTest.BLOCK_SLOW] = 6
        }
      }
    }
  }),
})

minetest.register_craft({
  output = "pyutest_magic:enchanted_pickaxe",
  recipe = {
    {"pyutest_magic:enchanted_shard", "pyutest_magic:enchanted_shard", "pyutest_magic:enchanted_shard"},
    {"", "pyutest_tools:stick", ""},
    {"", "pyutest_tools:stick", ""}
  }
})

PyuTest.make_tool("pyutest_magic:enchanted_axe", "Enchanted Axe", {}, "pyutest-enchanted-axe.png", {
  stack_max = 1,
  tool_capabilities = PyuTest.tool_caps({
    uses = 2768,
    attack_uses = 2768,
    damage_groups = {fleshy = 10},
    groupcaps = {
      choppy = {
        times = {
          [PyuTest.BLOCK_FAST] = 0.4,
          [PyuTest.BLOCK_NORMAL] = 0.6,
          [PyuTest.BLOCK_SLOW] = 0.8
        }
      }
    }
  })
})

minetest.register_craft({
  output = "pyutest_magic:enchanted_axe",
  recipe = {
    {"pyutest_magic:enchanted_shard", "pyutest_magic:enchanted_shard", ""},
    {"pyutest_magic:enchanted_shard", "pyutest_tools:stick", ""},
    {"", "pyutest_tools:stick", ""}
  }
})

PyuTest.make_sword("pyutest_magic:enchanted_sword", "Enchanted Sword", "pyutest-enchanted-sword.png", 9, 3600, 0.7)


minetest.register_craft({
  output = "pyutest_magic:enchanted_sword",
  recipe = {
    {"pyutest_magic:enchanted_shard"},
    {"pyutest_magic:enchanted_shard"},
    {"pyutest_tools:stick"}
  }
})


PyuTest.make_item("pyutest_magic:windball", "Windball", {}, "pyutest-windball.png", {
  stack_max = 16,
  on_use = function (_, user)
    if user == nil then
      return
    end

    local pos = user:get_pos()
    minetest.sound_play({name = "spellbook_action", gain = 0.75}, {pos = pos})

    local vel = user:get_velocity()

    user:add_velocity({
      x = vel.x * 2.5,
      z = vel.z * 2.5,
      y = math.random(11, 14)
    })

    local stack = user:get_wielded_item()
    stack:set_count(stack:get_count() - 1)

    user:set_wielded_item(stack)
  end
})
