PyuTest.LavaWorld = PyuTest.register_world({
  name = "lava_world",
  y_max = -3000,
  y_min = -3999
})
PyuTest.LavaWorld:create_token("pyutest_worlds:lava_world_token", "Lava World", "#511e1e", "pyutest_tools:ash")

local lava_cavern = PyuTest.LavaWorld:register_biome({
  name = "lava_cavern",
  node_stone = "pyutest_blocks:molten_rock_block",
  heat_point = 100,
  humidity_point = 0,
})

PyuTest.LavaWorld:register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:magma",
  wherein = "pyutest_blocks:molten_rock_block",
  clust_scarcity = 4.5 * 4.5 * 4.5,
  clust_num_ores = 6,
  clust_size = 5,
  biomes = {lava_cavern},
  noise_params = PyuTest.SPECIALSTONE_NOISE_PARAMS
})

PyuTest.LavaWorld:register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:lava_source",
  wherein = "pyutest_blocks:molten_rock_block",
  clust_scarcity = 9 * 9 * 9,
  clust_num_ores = 1,
  clust_size = 2,
  biomes = {lava_cavern},
  noise_params = PyuTest.SPECIALSTONE_NOISE_PARAMS
})
