PyuTest.make_item = function (nsname, desc, groups, wield_image, extra_conf)
  local conf = {
    description = Translate(desc),
    wield_image = wield_image,
    inventory_image = wield_image,
    groups = groups
  }

  if extra_conf ~= nil then
    for k, v in pairs(extra_conf) do
      conf[k] = v
    end
  end

  minetest.register_craftitem(nsname, conf)
end

PyuTest.make_tool = function (nsname, desc, groups, wield_image, extra_conf)
  local conf = {
    description = Translate(desc),
    wield_image = wield_image,
    inventory_image = wield_image,
    groups = PyuTest.util.tableconcat(groups, {
      tool = 1,
    })
  }

  if extra_conf ~= nil then
    for k, v in pairs(extra_conf) do
      conf[k] = v
    end
  end

  minetest.register_tool(nsname, conf)
end

PyuTest.make_sword = function (nsname, desc, texture, damage, durability, atkspeed)
  PyuTest.make_tool(nsname, desc, {
    weapon = 1,
    sword = 1
  }, texture, {
    stack_max = 1,
    tool_capabilities = PyuTest.tool_caps({
      uses = durability / 2,
      attack_uses = durability,
      damage_groups = {fleshy = damage or 3},
      full_punch_interval = atkspeed or 1
    })
  })
end

PyuTest.make_food = function (nsname, desc, wield_image, health_fill, cook_into, extra_code)
  PyuTest.make_item(nsname, desc, {
    food = 1
  }, wield_image, {
    on_use = function (itemstack, user, pt)
      if user == nil then return end
      minetest.sound_play({name = "eat", gain = 1}, {pos = user:get_pos(), start_time = 1.2})
      minetest.do_item_eat(health_fill, "", itemstack, user, pt)
      if extra_code then extra_code() end
    end,
  })

  if cook_into ~= nil then
    minetest.register_craft({
      type = "cooking",
      output = cook_into,
      recipe = nsname
    })
  end
end
