local modpath = minetest.get_modpath(minetest.get_current_modname())

dofile(modpath.."/stats.lua")

-- player setup
minetest.register_on_joinplayer(function (player)
  if player == nil then return end
  local name = player:get_player_name()

  player:get_inventory():set_width("main", 8)
  player:get_inventory():set_size("main", 8 * 4)
  player:hud_set_hotbar_itemcount(8)
  player:set_lighting({
    volumetric_light = { strength = 0.1 },
    saturation = 1.1,
  })

  -- creative mode privs
  if minetest.is_creative_enabled(name) then
    minetest.set_player_privs(name, PyuTest.util.tableconcat({
      fly = true,
      fast = true,
      noclip = true,
      settime = true,
      creative = true,
      teleport = true,
    }, minetest.get_player_privs(name)))
  end
end)

-- player physics
local function set_player_speed(player, speed)
  player:set_physics_override({
    speed = speed,
  })
end

minetest.register_globalstep(function(dtime)
  local players = minetest.get_connected_players()
  for p=1, #players do
    local ctrl = players[p]:get_player_control()
    if ctrl.aux1 then
      set_player_speed(players[p], 1.60)
    else
      set_player_speed(players[p], 1)
    end
  end
end)

-- player hand
minetest.register_item(":", {
  type = "none",
  description = "Hands",
  wield_image = "pyutest-hand.png",
  groups = {
    not_in_creative_inventory = 1
  }
})

if minetest.is_creative_enabled("")  then
  minetest.override_item("", {
    range = 9,
    tool_capabilities = PyuTest.tool_caps({
      uses = 0,
      time = 0.25,

      groupcaps = {
        crumbly = {},
        choppy = {},
        cracky = {},
        snappy = {},
        wooly = {},
        oddly_breakable_by_hand = {}
      },

      attack_uses = 0,
      damage_groups = {fleshy = 10000}
    })
  })
else
  minetest.override_item("", {
    range = 5,
    tool_capabilities = PyuTest.tool_caps({
      uses = 0,
      attck_uses = 0,
      damage_groups = {fleshy = 2},

      groupcaps = {
        oddly_breakable_by_hand = {
          times = {
            [PyuTest.BLOCK_FAST] = 0.35,
            [PyuTest.BLOCK_NORMAL] = 0.50,
            [PyuTest.BLOCK_SLOW] = 0.65,
          }
        },
        snappy = {
          times = {
            [PyuTest.BLOCK_FAST] = 0.55,
            [PyuTest.BLOCK_NORMAL] = 0.70,
            [PyuTest.BLOCK_SLOW] = 0.70
          }
        },
        crumbly = {
          times = {
            [PyuTest.BLOCK_FAST] = 0.75,
            [PyuTest.BLOCK_NORMAL] = 0.80,
            [PyuTest.BLOCK_SLOW] = 0.90
          }
        },
        choppy = {
          times = {
            [PyuTest.BLOCK_FAST] = 1.2,
            [PyuTest.BLOCK_NORMAL] = 2.3,
            [PyuTest.BLOCK_SLOW] = 2.9,
          }
        },
        cracky = {
          times = {
            [PyuTest.BLOCK_FAST] = 6,
            [PyuTest.BLOCK_NORMAL] = 10,
            [PyuTest.BLOCK_SLOW] = 45,
          }
        },
        wooly = {
          times = {
            [PyuTest.BLOCK_FAST] = 0.55,
            [PyuTest.BLOCK_NORMAL] = 0.70,
            [PyuTest.BLOCK_SLOW] = 0.70
          }
        },
      }
    })
  })
end

-- unlimited blocks in creative mode
minetest.register_on_placenode(function(_, _, placer)
  if placer and placer:is_player() then
    return minetest.is_creative_enabled(placer:get_player_name())
  end
end)

-- player death message
minetest.register_on_dieplayer(function(player, reason)
  local playername = player:get_player_name()

  local message = string.format("%s died", playername)
  if reason.type == "fall" then
    message = string.format("%s fell from a high place", playername)
  elseif reason.type == "drown" then
    message = string.format("%s drowned", playername)
  elseif reason.type == "respawn" then
    return
  elseif reason.type == "punch" then
    local entity = reason.object:get_luaentity()

    if entity ~= nil then
      local name = reason.object:get_properties().nametag or entity.name or "an unnamed monster!"
      message = string.format("%s was slain by %s", playername, name)
    else
      local name = reason.object:get_player_name()
      local itemname = reason.object:get_wielded_item():get_short_description()
      message = string.format("%s was slain by %s using %s", playername, name, itemname)
    end
  end

  minetest.chat_send_all(message)
end)

-- player lighting, and sky effects for different biomes
minetest.register_globalstep(function ()
  local players = minetest.get_connected_players()

  for _, player in pairs(players) do
    local pos = player:get_pos()
    local def = PyuTest.get_biome_def(pos)

    if def == nil then
      player:set_lighting(PyuTest.DEFAULT_EFFECTS.lighting)
      player:set_sky(PyuTest.DEFAULT_EFFECTS.sky)
      return
    end

    local sky_type = def._pyutest_sky_type or PyuTest.DEFAULT_EFFECTS.sky_type
    local sky_base_color = def._pyutest_sky_base_color or PyuTest.DEFAULT_EFFECTS.sky_base_color
    local fog_distance = def._pyutest_fog_distance or PyuTest.DEFAULT_EFFECTS.fog_distance
    local fog_start = def._pyutest_fog_start or PyuTest.DEFAULT_EFFECTS.fog_start
    local fog_color = def._pyutest_fog_color or PyuTest.DEFAULT_EFFECTS.fog_color

    player:set_sky({
      type = sky_type,
      base_color = sky_base_color,
      fog = {
        fog_distance = fog_distance,
        fog_start = fog_start,
        fog_color = fog_color
      }
    })
  end
end)
