PyuTest.FURNITURE_NODEBOXES = {
  TABLE = {
    type = "connected",
    fixed = {
      { -0.5,  0.5,  -0.5,  0.5,  0.45, 0.5 },
      { -0.15, -0.5, -0.15, 0.15, 0.45, 0.15 },
    },
  }
}

PyuTest.registered_furniture = {}
PyuTest.make_furniture = function(name, desc, craft, tiles, cgroups, extra_conf)
  local econf = extra_conf or {}
  local groups = PyuTest.util.tablecopy(cgroups) or {
    block = PyuTest.BLOCK_BREAKABLE_NORMAL
  }
  groups["block"] = groups["block"] or PyuTest.BLOCK_BREAKABLE_NORMAL
  groups["furniture"] = 1

  local id_table = name .. "_table"
  local id_chair = name .. "_chair"
  local id_mtable = name .. "_mtable"

  minetest.register_node(id_table, PyuTest.util.tableconcat({
    description = Translate(desc .. " Table"),
    tiles = tiles,
    groups = PyuTest.util.tableconcat(groups, {
      table = 1
    }),
    sounds = PyuTest.make_node_sounds(),
    drawtype = "nodebox",
    paramtype = "light",
    node_box = PyuTest.FURNITURE_NODEBOXES.TABLE,
    connects_to = { "group:table" }
  }, econf))

  minetest.register_node(id_chair, PyuTest.util.tableconcat({
    description = Translate(desc .. " Chair"),
    tiles = tiles,
    groups = PyuTest.util.tableconcat(groups, {
      chair = 1,
      attached_node = 3,
    }),
    sounds = PyuTest.make_node_sounds(),
    paramtype = "light",
    paramtype2 = "4dir",
    drawtype = "mesh",
    mesh = "pyutest-chair.obj",
    selection_box = {
      type = "fixed",
      fixed = { -0.5, -0.5, -0.5, 0.5, 1.1, 0.5 }
    },
    collision_box = {
      type = "fixed",
      fixed = {
        { -0.5, -0.5, -0.5, 0.5, 0.10, 0.5 }
      }
    }
  }, econf))

  minetest.register_node(id_mtable, PyuTest.util.tableconcat({
    description = Translate(desc .. " Mini Table"),
    tiles = tiles,
    groups = PyuTest.util.tableconcat(groups, {
      mtable = 1,
      attached_node = 3,
    }),
    sounds = PyuTest.make_node_sounds(),
    paramtype = "light",
    paramtype2 = "4dir",
    drawtype = "mesh",
    mesh = "pyutest-mtable.obj",
    selection_box = {
      type = "fixed",
      fixed = { -0.5, -0.5, -0.5, 0.5, 0.25, 0.5 }
    },
    collision_box = {
      type = "fixed",
      fixed = {
        { -0.5, -0.5, -0.5, 0.5, 0.25, 0.5 }
      }
    }
  }, econf))

  minetest.register_craft({
    output = id_table .. " 4",
    recipe = {
      { craft, craft, craft },
      { "",    craft, "" },
      { "",    craft, "" }
    }
  })

  minetest.register_craft({
    output = id_chair .. " 4",
    recipe = {
      { craft, "",    "" },
      { craft, craft, craft },
      { craft, "",    craft }
    }
  })

  minetest.register_craft({
    output = id_mtable .. " 4",
    recipe = {
      { craft, craft, craft },
      { craft, craft, craft }
    }
  })

  PyuTest.registered_furniture[name] = {
    craft = craft,
    groups = groups,
    tiles = tiles,
    econf = econf
  }
end

for _, v in pairs(PyuTest.building_blocks) do
  PyuTest.make_furniture("pyutest_furniture:"..v.name, v.desc, v.ns..":"..v.name .. "_block", v.tiles, v.groups, v.econf)
end
