PyuTest.registered_flowers = {}
PyuTest.make_flower = function (name, desc, texture, dye, add_to_registry, drawtype, econf)
  PyuTest.make_node(name, desc, {
    flammable = 1,
    flower = 1,
    attached_node = 3,
    dig_immediate = 1,
    oddly_breakable_by_hand = PyuTest.BLOCK_FAST,
    snappy = PyuTest.BLOCK_FAST
  }, {texture}, PyuTest.util.tableconcat({
    drawtype = drawtype or "plantlike",
    walkable = false,
    waving = 1,
    buildable_to = true,
    paramtype = "light",
    sunlight_propagates = true,
    inventory_image = texture,
    floodable = true
  }, econf or {}))

  if dye ~= nil then
    minetest.register_craft({
      output = dye .. " 2",
      recipe = {name},
      type = "shapeless"
    })
  end

  -- This is for plants like deadbushes which I do not want spawning in for say, Forests.
  if add_to_registry then
    table.insert(PyuTest.registered_flowers, name)
  end
end

PyuTest.make_flower("pyutest_flowers:rose", "Rose", "pyutest-flower.png", "pyutest_flowers:red_dye", true)
PyuTest.make_flower("pyutest_flowers:dandelion", "Dandelion", "pyutest-flower2.png", "pyutest_flowers:yellow_dye", true)
PyuTest.make_flower("pyutest_flowers:blue_daisy", "Blue Daisy", "pyutest-flower3.png", "pyutest_flowers:blue_dye", true)
PyuTest.make_flower("pyutest_flowers:lavender", "Lavender", "pyutest-flower4.png", "pyutest_flowers:purple_dye", true)

PyuTest.make_flower("pyutest_flowers:deadbush", "Deadbush", "pyutest-deadbush.png", "pyutest_flowers:brown_dye")
PyuTest.make_flower("pyutest_flowers:maybell", "Maybell", "pyutest-maybell.png", "pyutest_flowers:white_dye", true)
PyuTest.make_flower("pyutest_flowers:orange_tulip", "Orange Tulip", "pyutest-orange-tulip.png", "pyutest_flowers:orange_dye", true)
PyuTest.make_flower("pyutest_flowers:black_rose", "Black Rose", "pyutest-black-rose.png", "pyutest_flowers:black_dye", false)

PyuTest.make_node("pyutest_flowers:vines", "Vines", {
  snappy = PyuTest.BLOCK_FAST,
  flammable = 1,
}, {"pyutest-vines.png"}, {
  drawtype = "signlike",
  paramtype = "light",
  walkable = false,
  climbable = true,
  buildable_to = true,
  sunlight_propagates = true,
  waving = 2,
  paramtype2 = "wallmounted",
  selection_box = {
    type = "wallmounted"
  },
  inventory_image = "pyutest-vines.png"
})


PyuTest.make_node("pyutest_flowers:lilypad", "Lily Pad", {
  oddly_breakable_by_hand = PyuTest.BLOCK_FAST,
  dig_immediate = 1,
}, {"pyutest-lilypad.png"}, {
  drawtype = "signlike",
  paramtype = "light",
  paramtype2 = "facedir",
  buildable_to = true,
  sunlight_propagates = true,
  selection_box = {
    type = "fixed",
    fixed = {-0.5, -31/64, -0.5, 0.5, -15/32, 0.5}
  },
  collision_box = {
    type = "fixed",
    fixed = {-0.5, -31/64, -0.5, 0.5, -15/32, 0.5}
  },
})

PyuTest.make_flower("pyutest_flowers:sugarcane", "Sugarcane", "pyutest-sugarcane.png", "pyutest_flowers:green_dye", false, nil)
PyuTest.make_node("pyutest_flowers:sugarcane", "Sugarcane", {
  oddly_breakable_by_hand = PyuTest.BLOCK_FAST,
  dig_immediate = 1,
}, {"pyutest-sugarcane.png"}, {
  drawtype = "plantlike",
  paramtype = "light",
  sunlight_propagates = true,
  walkable = false,
})

PyuTest.make_flower("pyutest_flowers:kelp", "Kelp", "pyutest-kelp.png", "pyutest_flowers:green_dye", false, "plantlike_rooted", {
  paramtype2 = "leveled",
  place_param2 = 16,
  wield_image = "pyutest-kelp.png",
  special_tiles = {
    {
      image = "pyutest-kelp.png",
      tileable_vertical = true
    },
  },
  tiles = {
    "pyutest-gravel.png"
  },

  walkable = true
})


PyuTest.make_flower("pyutest_flowers:small_mushroom", "Small Mushroom", "pyutest-mushroom-small.png", "pyutest_flowers:red_dye", false, nil, {
  groups = {
    oddly_breakable_by_hand = PyuTest.BLOCK_FAST,
    flammable = 1,
    flower = 1,
    dig_immediate = 1,
    attached_node = 1
  },

  paramtype2 = "wallmounted"
})
