minetest.register_chatcommand("biome", {
  description = "Return the current biome name",
  func = function (name)
    local player = minetest.get_player_by_name(name)
    if player == nil then return end

    local pos = player:get_pos()

    local name = minetest.get_biome_name(minetest.get_biome_data(pos).biome)
    return true, string.format("Current biome name: %s", name)
  end
})

minetest.register_chatcommand("day", {
  description = "Return the current day",
  func = function (name)
    local day = minetest.get_day_count()
    return true, string.format("Current day is: %d", day)
  end
})
