PyuTest.IceWorld = PyuTest.register_world({
  name = "ice_world",
  y_max = -1000,
  y_min = -1999,
  sky_color = "#555588"
})
PyuTest.IceWorld:create_token("pyutest_worlds:ice_world_token", "Ice World", "#cbdbfc", "pyutest_blocks:ice_block")

local icy_cavern = PyuTest.IceWorld:register_biome("icy_cavern", PyuTest.BIOME_TYPES.COLD, {
  node_stone = "pyutest_blocks:ice_block",
  heat_point = -10,
  humidity_point = 0
})

PyuTest.IceWorld:register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:snow_block",
  wherein = "pyutest_blocks:ice_block",
  clust_scarcity = 3 * 3 * 3,
  clust_num_ores = 35,
  clust_size = 5,
  biomes = {icy_cavern},
  noise_params = PyuTest.SPECIAL_STONE_NOISE_PARAMS
})

PyuTest.IceWorld:register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:crystal_lantern_block",
  wherein = "pyutest_blocks:ice_block",
  clust_scarcity = 4.5 * 4.5 * 4.5,
  clust_num_ores = 6,
  clust_size = 5,
  biomes = {icy_cavern},
  noise_params = PyuTest.SPECIAL_STONE_NOISE_PARAMS
})
