mobs:register_mob("pyutest_mobs:monster", {
  type = "monster",
  hp_max = 20,
  hp_min = 20,
  walk_velocity = 1,
  run_velocity = 3,
  armor = 100,
  passive = false,
  walk_chance = 0,
  stand_chance = 25,
  damage = 2.7,
  attack_chance = 1,
  attack_type = "dogfight",
  pathfinding = 1,
  visual = "upright_sprite",
  visual_size = {x = 1, y = 2},
  collisionbox = PyuTest.HUMAN_LIKE_CBOX,
  physical = true,
  blood_amount = PyuTest.ENTITY_BLOOD_AMOUNT,
  view_range = 30,
  reach = 2,
  jump = 1,
  group_attack = true,
  makes_footstep_sound = true,

  textures = {
    "pyutest-monster.png", "pyutest-monster_back.png"
  },

  drops = {
    {
      name = "pyutest_tools:bone",
      min = 2,
      max = 3,
      chance = 1
    }
  }
})
mobs:register_egg("pyutest_mobs:monster", "Monster Spawn Egg", "pyutest-egg.png^[multiply:darkgreen", 0)

mobs:register_mob("pyutest_mobs:human", {
  type = "npc",
  hp_max = 20,
  hp_min = 20,
  walk_velocity = 1,
  run_velocity = 5,
  armor = 100,
  passive = true,
  walk_chance = 50,
  stand_chance = 50,
  damage = 3,
  attack_type = "dogfight",
  pathfinding = 1,
  visual = "upright_sprite",
  visual_size = {x = 1, y = 2},
  collisionbox = PyuTest.HUMAN_LIKE_CBOX,
  textures = {"player.png", "player_back.png"},
  follow = {"pyutest_tools:coin"},
  runaway = true,
  view_range = 15,
  reach = 2,
  fear_height = 7,
  blood_amount = PyuTest.ENTITY_BLOOD_AMOUNT,
  makes_footstep_sound = true,
  drops = {
    {
      name = "pyutest_tools:bone",
      min = 2,
      max = 3,
      chance = 1
    },
    {
      name = "pyutest_tools:apple",
      min = 1,
      max = 4,
      chance = 2.5
    }
  }
})
mobs:register_egg("pyutest_mobs:human", "Human Spawn Egg", "pyutest-egg.png^[multiply:peachpuff", 0)

mobs:register_mob("pyutest_mobs:mimic", {
  type = "monster",
  hp_max = 15,
  hp_min = 15,
  walk_velocity = 1,
  run_velocity = 3,
  armor = 100,
  passive = false,
  stand_chance = 1,
  walk_chance = 0,
  damage = 4,
  attack_type = "dogfight",
  pathfinding = 1,
  visual = "cube",
  visual_size = {x = 1, y = 1, z = 1},
  collisionbox = {
    -0.25, -0.5, -0.25, 0.25, 0.5, 0.25
  },
  textures = {
    "pyutest-crate.png",
    "pyutest-crate.png",
    "pyutest-crate.png",
    "pyutest-crate.png",
    "pyutest-crate.png",
    "pyutest-crate.png"
  },
  view_range = 12,
  blood_amount = PyuTest.ENTITY_BLOOD_AMOUNT,
  reach = 2,
})
mobs:register_egg("pyutest_mobs:mimic", "Mimic Spawn Egg", "pyutest-egg.png^[multiply:brown", 0)

mobs:register_mob("pyutest_mobs:firefly", {
  type = "animal",
  hp_max = 3,
  hp_min = 3,
  walk_velocity = 1,
  run_velocity = 3,
  armor = 100,
  passive = true,
  stand_chance = 0,
  walk_chance = 100,
  fly = true,
  keep_flying = true,
  visual = "sprite",
  visual_size = {x = 0.05, y = 0.05},
  collisionbox = {
    -0.0, -0.0, -0.0, 0.0, 0.0, 0.0
  },
  textures = {"pyutest-firefly.png"},
  blood_amount = PyuTest.ENTITY_BLOOD_AMOUNT,
  glow = 7,
})
mobs:register_egg("pyutest_mobs:firefly", "Firefly Spawn Egg", "pyutest-egg.png^[multiply:yellow", 0)
