PyuTest.make_node_sounds = function(tbl)
  local t = tbl or {}
  t.footstep = t.footstep or { name = "block_walk", gain = 1 }
  t.dig = t.dig or { name = "block_dig", gain = 0.50 }
  t.dug = t.dug or { name = "block_break", gain = 0.50 }
  t.place = t.place or { name = "block_place", gain = 0.50 }
  return t
end

PyuTest.make_node = function(name, desc, groups, tiles, extra_conf)
  local conf = {
    description = Translate(desc),
    tiles = tiles,
    groups = PyuTest.util.tableconcat(groups, {
      block = 1
    }),
  }
  conf["sounds"] = PyuTest.make_node_sounds()

  if extra_conf ~= nil then
    for k, v in pairs(extra_conf) do
      conf[k] = v
    end

    conf["sounds"] = PyuTest.make_node_sounds(extra_conf.sounds)
  end

  minetest.register_node(name, conf)
end

PyuTest.NODE_BOXES = {
  CARPET = {
    type = "fixed",
    fixed = { -0.5, -0.5, -0.5, 0.5, -0.45, 0.5 }
  },
  SLAB = {
    type = "fixed",
    fixed = { -0.5, -0.5, -0.5, 0.5, 0, 0.5 }
  },
  PILLAR = {
    type = "fixed",
    fixed = { -0.15, -0.5, -0.15, 0.15, 0.5, 0.15 }
  },
  STAIRS = {
    type = "fixed",
    fixed = {
      { -0.5, -0.5, -0.5, 0.5, 0,   0.5 },
      { -0.5, 0,    0,    0.5, 0.5, 0.5 },
    },
  },
  SLIGHTLY_SMALLER = {
    type = "fixed",
    fixed = {
      {-0.5, -0.5, -0.5, 0.5, 0.45, 0.5},
    }
  }
}
PyuTest.building_blocks = {}

PyuTest.make_building_blocks = function(name, desc, tex, colortint, cgroups, extra_conf)
  local groups = PyuTest.util.tablecopy(cgroups) or {}
  groups["block"] = 1

  local econf = extra_conf or {}
  econf["is_ground_content"] = econf["is_ground_content"] or true
  econf["color"] = colortint

  local id_block = name .. "_block"
  local id_carpet = name .. "_carpet"
  local id_slab = name .. "_slab"
  local id_pillar = name .. "_pillar"
  local id_stairs = name .. "_stairs"
  local id_fence = name .. "_fence"


  table.insert(PyuTest.building_blocks, {
    ns = name:split(":")[1],
    name = name:split(":")[2],
    desc = desc,
    tiles = tex,
    groups = groups,
    econf = econf
  })

  minetest.register_node(id_block, PyuTest.util.tableconcat({
    description = Translate(desc .. " Block"),
    tiles = tex,
    groups = PyuTest.util.tableconcat(groups, {
      solid = 1
    }),
    sounds = PyuTest.make_node_sounds(),
  }, econf))

  minetest.register_node(id_carpet, PyuTest.util.tableconcat({
    description = Translate(desc .. " Carpet"),
    tiles = tex,
    groups = PyuTest.util.tableconcat(PyuTest.util.tablecopy(groups), {
      attached_node = 1
    }),
    drawtype = "nodebox",
    paramtype = "light",
    paramtype2 = "facedir",
    node_box = PyuTest.NODE_BOXES.CARPET,
    sounds = PyuTest.make_node_sounds(),
    buildable_to = true,
    floodable = true
  }, econf))

  minetest.register_node(id_slab, PyuTest.util.tableconcat({
    description = Translate(desc .. " Slab"),
    tiles = tex,
    groups = groups,
    drawtype = "nodebox",
    paramtype = "light",
    paramtype2 = "facedir",
    node_box = PyuTest.NODE_BOXES.SLAB,
    sounds = PyuTest.make_node_sounds(),
  }, econf))

  minetest.register_node(id_pillar, PyuTest.util.tableconcat({
    description = Translate(desc .. " Pillar"),
    tiles = tex,
    groups = groups,
    drawtype = "nodebox",
    paramtype = "light",
    node_box = PyuTest.NODE_BOXES.PILLAR,
    sounds = PyuTest.make_node_sounds()
  }, econf))

  minetest.register_node(id_stairs, PyuTest.util.tableconcat({
    description = Translate(desc .. " Stairs"),
    tiles = tex,
    groups = groups,
    drawtype = "nodebox",
    paramtype = "light",
    paramtype2 = "facedir",
    node_box = PyuTest.NODE_BOXES.STAIRS,
    sounds = PyuTest.make_node_sounds(),
  }, econf))

  minetest.register_node(id_fence, PyuTest.util.tableconcat({
    description = Translate(desc .. " Fence"),
    tiles = tex,
    groups = groups,
    drawtype = "fencelike",
    paramtype = "light",
    collision_box = {
      type = "fixed",
      fixed = { -0.25, -0.5, -0.25, 0.25, 0.9, 0.25 }
    },
    selection_box = PyuTest.NODEBOX_DEFAULT,
    sounds = PyuTest.make_node_sounds(),
  }, econf))

  minetest.register_craft({
    output = id_carpet .. " 2",
    recipe = {
      { id_block, id_block }
    }
  })

  minetest.register_craft({
    output = id_slab .. " 3",
    recipe = {
      { id_block, id_block, id_block }
    }
  })

  minetest.register_craft({
    output = id_pillar .. " 3",
    recipe = {
      { id_block },
      { id_block },
      { id_block }
    }
  })

  minetest.register_craft({
    output = id_stairs .. " 4",
    recipe = {
      { id_block, "",       "" },
      { id_block, id_block, "" },
      { id_block, id_block, id_block }
    }
  })

  minetest.register_craft({
    output = id_fence .. " 4",
    recipe = {
      { id_block, "pyutest_tools:stick", id_block },
      { id_block, "pyutest_tools:stick", id_block }
    }
  })
end

PyuTest.make_liquid = function(name, desc, groups, texture, speed, extra_conf)
  local function make_liquid_flags(liquidtype)
    local drawtype = ""

    if liquidtype == "source" then
      drawtype = "liquid"
    elseif liquidtype == "flowing" then
      drawtype = "flowingliquid"
    end

    local t = PyuTest.util.tableconcat({
      drawtype = drawtype,
      waving = 3,
      walkable = false,
      pointable = false,
      buildable_to = true,
      is_ground_content = false,
      use_texture_alpha = "blend",
      paramtype = "light",
      drop = "",
      drowning = 4,
      liquidtype = liquidtype,
      liquid_renewable = true,
      liquid_viscosity = speed or 1,
      liquid_alternative_flowing = name .. "_flowing",
      liquid_alternative_source = name .. "_source",
      paramtype2 = liquidtype == "flowing" and "flowingliquid" or nil,
      special_tiles = liquidtype == "flowing" and {
        {
          name = texture,
          backface_culling = false
        },
        {
          name = texture,
          backface_culling = true
        }
      } or nil
    }, extra_conf or {})
    return t
  end

  local g = groups or {}
  g["liquid"] = 1
  g["not_in_creative_inventory"] = 1

  PyuTest.make_node(name .. "_source", desc .. " Source", PyuTest.util.tableconcat(g, {
    liquid_source = 1
  }), { texture }, make_liquid_flags("source"))
  PyuTest.make_node(name .. "_flowing", "Flowing " .. desc, g, { texture }, make_liquid_flags("flowing"))
end
