PyuTest.make_item("pyutest_buckets:bucket", "Empty Bucket", {}, "pyutest-bucket.png", {
  pointabilities = {
    nodes = {
      ["group:liquid_source"] = true
    }
  },

  on_place = function (itemstack, user, pointed_thing)
    if user == nil then
      return
    end

    if pointed_thing.type == "node" then
      local pos = pointed_thing.under
      local node = minetest.get_node(pos)
      local def = minetest.registered_nodes[node.name]

      if def.__bucket then
        PyuTest.give_item_or_drop(ItemStack(def.__bucket), user:get_inventory(), "main", user:get_pos())
        minetest.remove_node(pos)

        itemstack:take_item()
        return itemstack
      end
    end
  end
})

minetest.register_craft({
  output = "pyutest_buckets:bucket",
  recipe = {
    {"pyutest_ores:iron_ingot", "", "pyutest_ores:iron_ingot"},
    {"", "pyutest_ores:iron_ingot", ""}
  }
})

PyuTest.make_liquid_bucket = function (name, desc, source, color)
  local texture = string.format("pyutest-bucket.png^(pyutest-bucket-overlay.png^[colorize:%s)", color)

  PyuTest.make_node(name, desc, {
    bucket = 1
  }, {}, {
    drawtype = "airlike",
    walkable = false,
    pointable = false,
    wield_image = texture,
    inventory_image = texture,

    after_place_node = function (pos, placer)
      if placer == nil then return end
      PyuTest.give_item_or_drop(ItemStack("pyutest_buckets:bucket"), placer:get_inventory(), "main", placer:get_pos())
      minetest.set_node(pos, {name = source})
    end,
  })

  minetest.override_item(source, {
    __bucket = name,
  })
end

PyuTest.make_liquid_bucket("pyutest_buckets:water_bucket", "Water Bucket", "pyutest_blocks:water_source", "blue")
PyuTest.make_liquid_bucket("pyutest_buckets:lava_bucket", "Lava Bucket", "pyutest_blocks:lava_source", "orange")
