PyuTest.registered_lootboxes = {}
PyuTest.spawning_lootboxes = {}
PyuTest.make_lootbox = function (name, dname, items, spawn)
  local id = name.."_lootbox"
  minetest.register_node(id, {
    description = Translate(dname .. " Lootbox"),
    groups = {
      choppy = PyuTest.BLOCK_NORMAL,
      not_in_creative_inventory = 1
    },
    tiles = {"pyutest-crate.png"},
    sounds = PyuTest.make_node_sounds(),
    drop = "",
    after_destruct = function (pos)
      for _, v in pairs(items) do
        minetest.add_item(pos, v)
      end

      minetest.sound_play("lootbox_unlock", {
        pos = pos,
        gain = 1
      })
      minetest.remove_node(pos)
    end
  })
  PyuTest.registered_lootboxes[name] = {
    id = id,
    items = items
  }

  if spawn == true then
    PyuTest.spawning_lootboxes[#PyuTest.spawning_lootboxes+1] = id
  end
end

PyuTest.make_lootbox("pyutest_lootboxes:trash", "Trash", {
  ItemStack("pyutest_flowers:deadbush 6"),
  ItemStack("pyutest_tools:bone 3"),
  ItemStack("pyutest_tools:ash 2")
}, true)

PyuTest.make_lootbox("pyutest_lootboxes:resource", "Resource", {
  ItemStack("pyutest_tools:gunpowder 3"),
  ItemStack("pyutest_tools:stick 4"),
  ItemStack("pyutest_tools:sugar 2"),
  ItemStack("pyutest_tools:apple 3"),
  ItemStack("pyutest_tools:string 5")
}, true)

PyuTest.make_lootbox("pyutest_lootboxes:griefer", "Griefer's Dream", {
  ItemStack("pyutest_blocks:tnt 3"),
  ItemStack("pyutest_tools:bomb 2")
}, true)

PyuTest.make_lootbox("pyutest_lootboxes:lighting", "Lighting", {
  ItemStack("pyutest_blocks:light 2"),
  ItemStack("pyutest_blocks:torch 5")
}, true)

PyuTest.make_lootbox("pyutest_lootboxes:color", "Color", {
  ItemStack("pyutest_wool:green_dye 2"),
  ItemStack("pyutest_wool:pink_dye 3"),
  ItemStack("pyutest_wool:white_dye 1"),
  ItemStack("pyutest_wool:black_dye 3"),
  ItemStack("pyutest_wool:brown_dye 2")
})

PyuTest.make_lootbox("pyutest_lootboxes:farming", "Farmer's", {
  ItemStack("pyutest_farming:wheat_seeds 5"),
  ItemStack("pyutest_farming:carrot_seeds 3"),
  ItemStack("pyutest_farming:potato_seeds 3"),
  ItemStack("pyutest_farming:pumpkin_seeds 4"),
}, true)
