if PyuTest.is_flat() then
  PyuTest.register_overworld_biome("flat", PyuTest.BIOME_TYPES.NORMAL, {
    node_top = "pyutest_grass:dark_grass_block",
    node_filler = "pyutest_blocks:dirt_block",

    y_max = PyuTest.BIOME_TOPS.normal,
    y_min = PyuTest.OVERWORLD_BOTTOM,

    heat_point = 50,
    humidity_point = 50,
  })

  return
end

-- Plains like biomes
PyuTest.register_overworld_biome("grassland", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_grass:grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 40,

  _pyutest_biome_flowering = true
})

PyuTest.register_overworld_biome("desert", PyuTest.BIOME_TYPES.HOT, {
  node_top = "pyutest_blocks:sand_block",
  node_filler = "pyutest_blocks:sandstone_block",
  node_riverbed = "pyutest_blocks:sand_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 80,
  humidity_point = 5,

  enable_beaches = false
})

PyuTest.register_overworld_biome("frozen_plains", PyuTest.BIOME_TYPES.COLD, {
  node_dust = "pyutest_blocks:snow_carpet",
  node_top = "pyutest_blocks:snow_block",
  node_filler = "pyutest_blocks:snow_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  node_water_top = "pyutest_blocks:ice_block",
  depth_water_top = 1,

  heat_point = 5,
  humidity_point = 60
})

PyuTest.register_overworld_biome("savanna", PyuTest.BIOME_TYPES.WARM, {
  node_top = "pyutest_grass:savanna_grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 70,
  humidity_point = 15
})

-- Forest like biomes
PyuTest.register_overworld_biome("forest", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_grass:dark_grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 60,

  _pyutest_biome_flowering = true
})

PyuTest.register_overworld_biome("mushroom_fields", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_blocks:mycelium_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 90,

  enable_beaches = false,
  _pyutest_fog_distance = 40,
})

PyuTest.register_overworld_biome("large_mushroom_forest", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_blocks:mycelium_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 90,

  enable_beaches = false,
  _pyutest_fog_distance = 40,
})

PyuTest.register_overworld_biome("snowy_forest", PyuTest.BIOME_TYPES.COLD, {
  node_dust = "pyutest_blocks:snow_carpet",
  node_top = "pyutest_blocks:snow_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  node_water_top = "pyutest_blocks:ice_block",
  depth_water_top = 5,

  heat_point = 5,
  humidity_point = 60
})

PyuTest.register_overworld_biome("taiga", PyuTest.BIOME_TYPES.CHILLY, {
  node_top = "pyutest_grass:dark_grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 15,
  humidity_point = 60,

  _pyutest_biome_flowering = true
})

PyuTest.register_overworld_biome("cherry_grove", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_grass:grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 70,

  _pyutest_biome_flowering = true,
  _pyutest_biome_flowering_extra = true
})


PyuTest.register_overworld_biome("birch_forest", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_grass:grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 60,

  _pyutest_biome_flowering = true
})

PyuTest.register_overworld_biome("old_growth_birch_forest", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_grass:grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 60,

  _pyutest_biome_flowering = true,
  _pyutest_biome_flowering_extra = true
})

PyuTest.register_overworld_biome("aspen_forest", PyuTest.BIOME_TYPES.CHILLY, {
  node_top = "pyutest_grass:aspen_grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 30,
  humidity_point = 50,

  _pyutest_biome_flowering = true,
  _pyutest_fog_distance = 40,
})

PyuTest.register_overworld_biome("redwood_forest", PyuTest.BIOME_TYPES.CHILLY, {
  node_top = "pyutest_blocks:podzol_block",
  node_filler = "pyutest_blocks:podzol_block",

  y_max = PyuTest.BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 30,
  humidity_point = 50,

  _pyutest_biome_flowering = true,
  _pyutest_fog_distance = 40,
})

-- Marsh biomes
PyuTest.register_overworld_biome("swamp", PyuTest.BIOME_TYPES.WETLAND, {
  node_top = "pyutest_grass:swampy_grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.BIOME_TOPS.lowland,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 80,

  enable_beaches = false,
  _pyutest_fog_distance = 40,
})

-- Mountainous biomes

PyuTest.register_overworld_biome("stony_mountains", PyuTest.BIOME_TYPES.WARM, {
  node_top = "pyutest_blocks:stone_block",
  node_filler = "pyutest_blocks:stone_block",

  y_max = PyuTest.BIOME_TOPS.mountains,
  y_min = PyuTest.BIOME_TOPS.normal,

  heat_point = 40,
  humidity_point = 10
}, true)

PyuTest.register_overworld_biome("desert_mountains", PyuTest.BIOME_TYPES.HOT, {
  node_top = "pyutest_blocks:sand_block",
  node_filler = "pyutest_blocks:sandstone_block",

  y_max = PyuTest.BIOME_TOPS.mountains,
  y_min = PyuTest.BIOME_TOPS.normal,

  heat_point = 80,
  humidity_point = 5
}, true)

PyuTest.register_overworld_biome("snowy_mountains", PyuTest.BIOME_TYPES.COLD, {
  node_dust = "pyutest_blocks:snow_carpet",
  node_top = "pyutest_blocks:snow_block",
  node_filler = "pyutest_blocks:snow_block",

  y_max = PyuTest.BIOME_TOPS.mountains,
  y_min = PyuTest.BIOME_TOPS.normal,

  heat_point = 5,
  humidity_point = 60
}, true)

PyuTest.register_overworld_biome("ice_spikes", PyuTest.BIOME_TYPES.COLD, {
  node_top = "pyutest_blocks:ice_block",
  node_filler = "pyutest_blocks:ice_block",

  y_max = PyuTest.BIOME_TOPS.mountains,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  node_water_top = "pyutest_blocks:ice_block",
  depth_water_top = 5,

  heat_point = 5,
  humidity_point = 60
})

PyuTest.register_overworld_biome("meadow", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_grass:dark_grass_block",
  node_filler = "pyutest_blocks:dirt_block",
  depth_filler = 4,

  y_max = PyuTest.BIOME_TOPS.mountains,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 60,

  _pyutest_biome_flowering = true,
  _pyutest_biome_flowering_extra = true
})
