minetest.register_alias("mapgen_stone", "pyutest_blocks:stone_block")
minetest.register_alias("mapgen_water_source", "pyutest_blocks:water_source")
minetest.register_alias("mapgen_river_water_source", "pyutest_blocks:water_source")
minetest.register_alias("mapgen_lava_source", "pyutest_blocks:lava_source")
minetest.register_alias("mapgen_singlenode", "air")

local mg_flags = minetest.settings:get_flags("mg_flags")
local mg_name = minetest.get_mapgen_setting("mg_name")
minetest.set_mapgen_setting(string.format("mg%s_cavern_threshold", mg_name), "0.20", true)
minetest.set_mapgen_setting(string.format("mg%s_mount_zero_level", mg_name), "1.4", true)

mg_flags.caverns = true
mg_flags.dungeons = false

-- https://git.minetest.land/VoxeLibre/VoxeLibre/src/branch/master/mods/MAPGEN/mcl_mapgen_core/init.lua#L127
local mg_flags_str = ""
for k,v in pairs(mg_flags) do
  if v == false then
    k = "no" .. k
  end
  mg_flags_str = mg_flags_str .. k .. ","
end
if string.len(mg_flags_str) > 0 then
  mg_flags_str = string.sub(mg_flags_str, 1, string.len(mg_flags_str)-1)
end
minetest.set_mapgen_setting("mg_flags", mg_flags_str, true)
