PyuTest.LavaWorld = PyuTest.register_world({
  name = "lava_world",
  y_max = -3000,
  y_min = -3999,
  sky_color = "#330000"
})
PyuTest.LavaWorld:create_token("pyutest_worlds:lava_world_token", "Lava World", "#511e1e", "pyutest_tools:ash")

local node_stones = {
  "pyutest_blocks:molten_rock_block",
  "pyutest_blocks:basalt_block"
}

local lava_cavern = PyuTest.LavaWorld:register_biome("lava_cavern", PyuTest.BIOME_TYPES.HOT, {
  node_stone = "pyutest_blocks:molten_rock_block",
  heat_point = 100,
  humidity_point = 0,
})

local basalt_volcano = PyuTest.LavaWorld:register_biome("basalt_volcano", PyuTest.BIOME_TYPES.HOT, {
  node_stone = "pyutest_blocks:basalt_block",
  heat_point = 100,
  humidity_point = 0,
})

PyuTest.LavaWorld:register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:magma",
  wherein = "pyutest_blocks:molten_rock_block",
  clust_scarcity = 4.5 * 4.5 * 4.5,
  clust_num_ores = 6,
  clust_size = 5,
  biomes = {lava_cavern},
  noise_params = PyuTest.SPECIAL_STONE_NOISE_PARAMS
})

PyuTest.LavaWorld:register_ore({
  ore_type = "blob",
  ore = "pyutest_blocks:lava_source",
  wherein = node_stones,
  clust_scarcity = 9 * 9 * 9,
  clust_num_ores = 1,
  clust_size = 2,
  biomes = PyuTest.LavaWorld.biome_names,
  noise_params = PyuTest.SPECIAL_STONE_NOISE_PARAMS
})

PyuTest.make_ore("pyutest_worlds:magic_shards_ore", "Magic Shards Ore", {
  scarcity = 12 * 12 * 12,
  wherein = {"pyutest_blocks:molten_rock_block"},
  y_max = PyuTest.LavaWorld.y_max,
  y_min = PyuTest.LavaWorld.y_min,

  ore_strength = PyuTest.BLOCK_NORMAL,
  ore_drop = "pyutest_magic:magic_shards",
  ore_color = "#24152a",
  ore_stone = {"pyutest-molten-rock.png"},
  ore_conf = {
    light_source = 6
  }
})
