PyuTest.make_node("pyutest_blocks:sponge", "Sponge", {
  oddly_breakable_by_hand = PyuTest.BLOCK_FAST
}, { "pyutest-sponge.png" })

PyuTest.make_node("pyutest_blocks:light", "Light", {
  light = 1,
  dig_immediate = 1,
  oddly_breakable_by_hand = PyuTest.BLOCK_FAST
}, {
  "pyutest-light.png"
}, {
  drawtype = "torchlike",
  walkable = false,
  paramtype = "light",
  sunlight_propagates = true,
  light_source = minetest.LIGHT_MAX,
  floodable = true
})

PyuTest.make_node("pyutest_blocks:torch", "Torch", {
  dig_immediate = 1,
  light = 1,
  attached_node = 1,
  emits_heat = 1,
  oddly_breakable_by_hand = PyuTest.BLOCK_FAST
}, {
  "pyutest-torch.png",
  "pyutest-torch.png^[transform6",
  "pyutest-torch.png^[transform1"
}, {
  light_source = minetest.LIGHT_MAX,
  walkable = false,
  drawtype = "torchlike",
  paramtype = "light",
  inventory_image = "pyutest-torch.png",
  paramtype2 = "wallmounted",
  floodable = true
})

PyuTest.make_node("pyutest_blocks:glass", "Glass", {
  cracky = PyuTest.BLOCK_FAST
}, { "pyutest-glass.png", "pyutest-glass-overlay.png" }, {
  drawtype = "glasslike_framed",
  paramtype = "light",
  sunlight_propagates = true
})

-- FIXME: This has been in the game for months, implement it already!
PyuTest.make_node("pyutest_blocks:trapdoor", "Trapdoor", {
  choppy = PyuTest.BLOCK_NORMAL,
  flammable = 1
}, { "pyutest-trapdoor.png" }, {
  drawtype = "nodebox",
  paramtype = "light",
  sunlight_propagates = true,
  node_box = {
    type = "fixed",
    fixed = { -0.5, -0.5, -0.5, 0.5, -0.15, 0.5 }
  }
})

PyuTest.make_node("pyutest_blocks:contagious_acid", "Contagious Acid", {
  crumbly = PyuTest.BLOCK_NORMAL,
  solid_node = 1
}, { "pyutest-acid.png" }, {})

PyuTest.make_node("pyutest_blocks:fire", "Fire", {
  dig_immediate = 1,
  oddly_breakable_by_hand = PyuTest.BLOCK_FAST,
  emits_heat = 1
}, { "pyutest-fire.png" }, {
  drawtype = "firelike",
  walkable = false,
  buildable_to = true,
  paramtype = "light",
  sunlight_propagates = true,
  damage_per_second = 2,
  light_source = 8,
  drop = "pyutest_tools:ash 4"
})

PyuTest.make_node("pyutest_blocks:tnt", "TNT", {
  dig_immediate = 1,
  oddly_breakable_by_hand = PyuTest.BLOCK_FAST
}, {
  "pyutest-tnt-top-bottom.png",
  "pyutest-tnt-top-bottom.png",
  "pyutest-tnt-side.png" -- Affects all other sides
}, {
  on_rightclick = function(pos, node, clicker)
    minetest.after(3, function()
      if minetest.get_node(pos).name ~= "pyutest_blocks:tnt" then
        return
      end
      PyuTest.create_explosion(pos, 3, true, 12)
    end)
  end,

  __on_electricity_activated = function(pos, node, sender_pos)
    minetest.after(3, function()
      if minetest.get_node(pos).name ~= "pyutest_blocks:tnt" then
        return
      end
      PyuTest.create_explosion(pos, 3, true, 12)
    end)
  end,
})

PyuTest.make_node("pyutest_blocks:crate", "Crate", {
  choppy = PyuTest.BLOCK_NORMAL
}, { "pyutest-crate.png" }, {
  on_construct = function(pos)
    local meta = minetest.get_meta(pos)
    local inventory = meta:get_inventory()
    inventory:set_size("main", 8 * 4)
  end,

  can_dig = function(pos, player)
    local meta = minetest.get_meta(pos)
    local inventory = meta:get_inventory()
    local empty = inventory:is_empty("main")

    if not empty then
      minetest.chat_send_player(player:get_player_name(), "Cannot destroy crate, it's not empty!")
    end

    return empty
  end,

  on_rightclick = function(pos, node, clicker)
    local spos = string.format("%d,%d,%d", pos.x, pos.y, pos.z)
    local formspec =
    "size[8,9]" ..
    "list[nodemeta:" .. spos .. ";main;0,0;8,4;]" ..
    "list[current_player;main;0,5;8,4;]" ..
    "listring[nodemeta:" .. spos .. ";main]" ..
    "listring[current_player;main]"
    minetest.show_formspec(clicker:get_player_name(), string.format("pyutest_blocks:crate_%d_%d_%d", pos.x, pos.y, pos.z),
    formspec)
    minetest.sound_play({ name = "crate_open", gain = 1 }, { pos = pos })
  end
})

PyuTest.make_node("pyutest_blocks:workbench", "Workbench", {
  choppy = PyuTest.BLOCK_NORMAL
}, {
  "pyutest-workbench-top.png",
  "pyutest-workbench-bottom.png",
  "pyutest-workbench-sides.png"
}, {
  on_rightclick = function(pos, node, clicker)
    minetest.show_formspec(clicker:get_player_name(), "pyutest_blocks:workbench", table.concat({
      "size[8,7.5]",
      "list[current_player;craft;2.5,0;3,3;]",
      "list[current_player;craftpreview;6.5,1;1,1;]",
      "list[current_player;main;0,3.5;8,4;]"
    }))
  end
})

PyuTest.make_node("pyutest_blocks:ladder", "Ladder", {
  dig_immediate = 1
}, { "pyutest-ladder.png" }, {
  drawtype = "signlike",
  paramtype = "light",
  walkable = false,
  climbable = true,
  buildable_to = true,
  sunlight_propagates = true,
  paramtype2 = "wallmounted",
  selection_box = {
    type = "wallmounted"
  },
  collision_box = {
    type = "wallmounted"
  },
  inventory_image = "pyutest-ladder.png"
})

PyuTest.make_node("pyutest_blocks:magma", "Magma", {
  cracky = PyuTest.BLOCK_FAST
}, { "pyutest-molten-rock.png" }, {
  paramtype = "light",
  light_source = 11,
  overlay_tiles = {
    {name = "pyutest-ore-overlay.png", color = "darkorange"}
  },
  on_walk_over = function (pos, node, player)
    if player then
      PyuTest.deal_damage(player, 3)
    end
  end
})

PyuTest.make_node("pyutest_blocks:bedrock", "Bedrock", {
}, {"pyutest-bedrock.png"}, {
  diggable = false,
  pointable = "blocking",
  is_ground_content = false
})

PyuTest.make_node("pyutest_blocks:weak_ice", "Weak Ice", {
  cracky = PyuTest.BLOCK_FAST
}, {"pyutest-ice.png"}, {
  on_walk_over = function(pos)
    minetest.set_node(pos, {name = "pyutest_blocks:water_source"})
  end
})

minetest.register_abm({
  label = "Sponge Loop",
  nodenames = { "pyutest_blocks:sponge" },
  neighbors = { "group:liquid" },
  interval = 0,
  chance = 1,
  action = function(pos)
    local range = 4

    local function replace(npos)
      local node = minetest.get_node(npos)
      if node.name == "air" then return end
      local def = minetest.registered_nodes[node.name]

      if def.groups["liquid"] == 1 then
        minetest.remove_node(npos)
      end
    end

    PyuTest.dorange(pos, range, function(p)
      replace(p)
    end)
  end
})

minetest.register_abm({
  label = "Contagious Acid Spread",
  nodenames = { "group:acid_vulnerable" },
  neighbors = { "pyutest_blocks:contagious_acid" },
  interval = 2.4,
  chance = 2.2,
  catchup = true,
  action = function(pos)
    if not minetest.settings:get_bool("acid_spreads", true) then
      return
    end

    minetest.set_node(pos, {
      name = "pyutest_blocks:contagious_acid"
    })
  end
})

minetest.register_abm({
  label = "Fire Spread",
  nodenames = { "group:flammable" },
  neighbors = { "pyutest_blocks:fire" },
  interval = 1,
  chance = 4,
  action = function(pos)
    if not minetest.settings:get_bool("fire_spreads", true) then
      return
    end

    minetest.set_node(pos, {
      name = "pyutest_blocks:fire"
    })
  end
})
