minetest.register_abm({
  label = "Water freezing/evaporating",
  nodenames = {"group:water"},
  interval = 1.2,
  chance = 1.8,
  catch_up = true,
  action = function (pos)
    if pos.y < PyuTest.OVERWORLD_SURFACE_BOTTOM and pos.y >= PyuTest.OVERWORLD_DEEP_OCEAN_MIN then
      return
    end

    local def = PyuTest.get_biome_def(pos)
    if not def then return end

    local heat = def.heat_point or 50
    local found = minetest.find_node_near(pos, 2, {"group:emits_heat"}) ~= nil

    if heat <= 12 and not found then
      minetest.set_node(pos, {name = "pyutest_blocks:ice_block"})
    end
  end
})

minetest.register_abm({
  label = "Water evaporating",
  nodenames = {"group:water"},
  interval = 0.1,
  chance = 1,
  action = function (pos)
    local def = PyuTest.get_biome_def(pos)
    if not def then return end

    local heat = def.heat_point or 50

    if heat >= 95 then
      minetest.remove_node(pos)
    end
  end
})

minetest.register_abm({
  label = "Ice thawing",
  nodenames = {"group:thawable"},
  neighbors = {"group:emits_heat"},
  interval = 3,
  chance = 2.5,
  catch_up = true,
  action = function (pos, node)
    local def = minetest.registered_nodes[node.name]
    local thaw_into = def.__thaw_into or "pyutest_blocks:water_source"
    minetest.set_node(pos, { name = thaw_into })
  end
})

minetest.register_abm({
  nodenames = {"group:lava"},
  interval = 0.25,
  chance = 1,
  action = function (pos)
    local function is_water(p)
      local name = minetest.get_node(p).name

      if minetest.get_item_group(name, "water") ~= 0 then
        return true
      end
      
      return false
    end

    local function replace(name, p)
      minetest.set_node(p or pos, {name = name})
    end

    PyuTest.dorange(pos, 1, function (p)
      if is_water(p) then
        if p.y > pos.y then
          replace("pyutest_blocks:obsidian_block")
        elseif p.y < pos.y then
          replace("pyutest_blocks:stone_block", p)
        else
          replace("pyutest_blocks:stone_block")
        end
      end
    end)
  end
})
