PyuTest.make_grass = function(name, desc, groups, color, dont_make_flora, ttex, stex, dtex, econf)
  local _ttex = { name = ttex or "pyutest-grass-top.png", color = color }
  local _stex = { name = stex or "pyutest-grass-side.png", color = color }
  local _dtex = { _ttex, dtex or "pyutest-dirt.png" }

  PyuTest.make_building_blocks(name, desc, _dtex, nil, PyuTest.util.tableconcat(groups or {}, {
    ground = 1,
    grass = 1,
    dirt = 1,
  }), {
    overlay_tiles = { "", "", _stex }
  })

  local function make_drops(name)
    return {
      max_items = 1,
      items = {
        {
          tool_groups = {
            "shears"
          },
          items = { name }
        }
      }
    }
  end

  if dont_make_flora ~= true then
    PyuTest.make_flower(name .. "_plant", desc .. " Plant", "pyutest-grass-plant.png", nil, false, nil, {
      color = color,
      drop = make_drops(name .. "_plant")
    })

    PyuTest.make_flower(name .. "_fern", desc .. " Fern", "pyutest-fern.png", nil, false, nil, {
      color = color,
      drop = make_drops(name .. "_fern")
    })
  end

  core.override_item(name .. "_block", econf or {})
  core.register_craft({
    output = name .. "_block 2",
    recipe = {
      name .. "_block", "pyutest_blocks:dirt_block"
    },
    type = "shapeless"
  })

  core.register_decoration({
    deco_type = "simple",
    place_on = { name .. "_block" },
    sidelen = 16,
    fill_ratio = 0.048,
    decoration = name .. "_plant"
  })

  core.register_decoration({
    deco_type = "simple",
    place_on = { name .. "_block" },
    sidelen = 16,
    fill_ratio = 0.022,
    decoration = name .. "_fern"
  })
end

PyuTest.make_grass("pyutest_grass:grass", "Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1
}, "#6baf4a")

PyuTest.make_grass("pyutest_grass:dark_grass", "Dark Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1
}, "#388b4a")

PyuTest.make_grass("pyutest_grass:swampy_grass", "Swampy Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1,
  sugarcane_spawn_on = 1
}, "#48592a")

PyuTest.make_grass("pyutest_grass:savanna_grass", "Savanna Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1,
  sugarcane_spawn_on = 1,
}, "#9faf4a")

PyuTest.make_grass("pyutest_grass:aspen_grass", "Aspen Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1,
}, "#ad9d4b")

PyuTest.make_grass("pyutest_grass:jungle_grass", "Jungle Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1,
}, "#3b562d")

PyuTest.make_grass("pyutest_grass:snowy_grass", "Snowy Grass", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1,
}, "#f2f6fb")

PyuTest.make_grass("pyutest_grass:dirt_path", "Dirt Path", {
  crumbly = PyuTest.BLOCK_FAST,
  acid_vulnerable = 1,
}, "#d9a066", true, nil, nil, nil, {
  drawtype = "nodebox",
  node_box = PyuTest.NODE_BOXES.SLIGHTLY_SMALLER,
  collision_box = PyuTest.NODE_BOXES.SLIGHTLY_SMALLER,
  selection_box = PyuTest.NODE_BOXES.SLIGHTLY_SMALLER
})
