PyuTest.registered_colored_blocks = {}
PyuTest.make_colored_blocks = function(name, desc, color)
  PyuTest.make_building_blocks(name .. "_wool", desc .. " Wool", {
    "pyutest-wool.png"
  }, color, {
    wooly = PyuTest.BLOCK_NORMAL,
    colored = 1,
  })

  PyuTest.make_building_blocks(name .. "_terracotta", desc .. " Terracotta", {
    "pyutest-terracotta.png"
  }, color, {
    cracky = PyuTest.BLOCK_NORMAL,
    colored = 1,
  }, {
    _pyutest_blast_resistance = 3
  })

  PyuTest.make_building_blocks(name .. "_concrete", desc .. " Concrete", {
    "pyutest-concrete.png"
  }, color, {
    cracky = PyuTest.BLOCK_NORMAL,
    colored = 1,
  }, {
      _pyutest_blast_resistance = 2
  })

  PyuTest.make_item(name .. "_dye", desc .. " Dye", {
    colored = 1,
    dye = 1
  }, "pyutest-dye.png", {
    color = color or "white"
  })

  core.register_craft({
    output = name .. "_wool_block",
    type = "shapeless",
    recipe = {
      "pyutest_wool:white_wool_block",
      name .. "_dye"
    }
  })

  core.register_craft({
    output = name .. "_terracotta_block",
    type = "shapeless",
    recipe = {
      "pyutest_wool:white_terracotta_block",
      name .. "_dye"
    }
  })

  core.register_craft({
    output = name .. "_concrete_block",
    type = "shapeless",
    recipe = {
      "pyutest_wool:white_concrete_block",
      name .. "_dye"
    }
  })

  PyuTest.registered_colored_blocks[name] = {
    wool = name .. "_wool",
    terracotta = name .. "_terracotta",
    dye = name .. "_dye"
  }
end

PyuTest.make_colored_blocks("pyutest_wool:white", "White", "white")
core.register_craft({
  output = "pyutest_wool:white_wool_block 4",
  recipe = {
    { "pyutest_tools:string", "pyutest_tools:string" },
    { "pyutest_tools:string", "pyutest_tools:string" }
  }
})

core.register_craft({
  type = "cooking",
  output = "pyutest_wool:white_terracotta_block",
  recipe = "pyutest_blocks:clay_block"
})

core.register_craft({
  output = "pyutest_wool:white_concrete_block 4",
  recipe = {
    "pyutest_blocks:clay_block"
  },
  type = "shapeless"
})

PyuTest.COLORS = {
  white       = { "White", nil },
  black       = { "Black", { r = 32, g = 32, b = 32 } },
  brown       = { "Brown", "#9F8170" },

  red         = { "Red", "red" },
  orange      = { "Orange", "orange" },
  yellow      = { "Yellow", "yellow" },
  green       = { "Green", "green" },
  blue        = { "Blue", "blue" },
  purple      = { "Purple", "purple" },
  pink        = { "Pink", "pink" },

  lime        = { "Lime", "#64C044" },
  cyan        = { "Cyan", "cyan" },
  magenta     = { "Magenta", "magenta" },
  chartreuse  = { "Chartreuse", "#7FFF00" },
  ultramarine = { "Ultramarine", "#120A8F" },
  violet      = { "Violet", "#8000FF" },
  rose        = { "Rose", "#FF0080" },
  chestnut    = { "Chestnut", "#954535" },
  turquoise   = { "Turquoise", "#40E0D0" },
  teal        = { "Teal", "#008080" },
  mauve       = { "Mauve", "#E0B0FF" },
  mint        = { "Mint", "#3EB489" },
  ecru        = { "Ecru", "#C2B280" },
  khaki       = { "Khaki", "khaki" },
  indigo      = { "Indigo", "#4000FF" },
}

for k, v in pairs(PyuTest.COLORS) do
  PyuTest.make_colored_blocks("pyutest_wool:" .. k, v[1], v[2])
end

for k, v in pairs(PyuTest.COLORS) do
  if v[2] ~= nil then
    local id = "pyutest_wool:" .. k .. "_stained_glass"

    PyuTest.make_node(id, v[1] .. " Stained Glass", {
      cracky = PyuTest.BLOCK_FAST,
      glass = 1,
      colored = 1
    }, { "pyutest-glass.png", "pyutest-glass-overlay.png" }, {
      drawtype = "glasslike_framed",
      color = v[2],
      paramtype = "light",
      sunlight_propagates = true
    })

    core.register_craft({
      output = id,
      recipe = {
        "pyutest_blocks:glass",
        "pyutest_wool:" .. k .. "_dye"
      },
      type = "shapeless"
    })
  end
end

PyuTest.make_dye_mixing_recipe = function(c1, c2, out)
  core.register_craft({
    type = "shapeless",
    output = out .. " 2",
    recipe = {
      c1, c2
    }
  })
end

PyuTest.make_dye_mixing_recipe("pyutest_wool:red_dye", "pyutest_wool:blue_dye", "pyutest_wool:purple_dye")
PyuTest.make_dye_mixing_recipe("pyutest_wool:red_dye", "pyutest_wool:yellow_dye", "pyutest_wool:orange_dye")
PyuTest.make_dye_mixing_recipe("pyutest_wool:yellow_dye", "pyutest_wool:blue_dye", "pyutest_wool:green_dye")
PyuTest.make_dye_mixing_recipe("pyutest_wool:red_dye", "pyutest_wool:white_dye", "pyutest_wool:pink_dye")
PyuTest.make_dye_mixing_recipe("pyutest_wool:red_dye", "pyutest_wool:green_dye", "pyutest_wool:brown_dye")
