if PyuTest.is_flat() then
  PyuTest.register_overworld_biome("flat", PyuTest.BIOME_TYPES.NORMAL, {
    node_top = "pyutest_grass:dark_grass_block",
    node_filler = "pyutest_blocks:dirt_block",

    y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
    y_min = PyuTest.OVERWORLD_BOTTOM,

    heat_point = 50,
    humidity_point = 50,
  })

  return
end

PyuTest.register_overworld_biome("Grassland", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_grass:grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 40,

  _pyutest_biome_flowering = true
})

PyuTest.register_overworld_biome("Desert", PyuTest.BIOME_TYPES.HOT, {
  node_top = "pyutest_blocks:sand_block",
  node_filler = "pyutest_blocks:sandstone_block",
  node_riverbed = "pyutest_blocks:sand_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 80,
  humidity_point = 10,

  enable_beaches = false
})

PyuTest.register_overworld_biome("FrozenPlains", PyuTest.BIOME_TYPES.COLD, {
  node_dust = "pyutest_blocks:snow_carpet",
  node_top = "pyutest_blocks:snow_block",
  node_filler = "pyutest_blocks:snow_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  node_water_top = "pyutest_blocks:ice_block",
  depth_water_top = 1,

  heat_point = 5,
  humidity_point = 60,
  _pyutest_fog_distance = 80,
})

PyuTest.register_overworld_biome("Savanna", PyuTest.BIOME_TYPES.WARM, {
  node_top = "pyutest_grass:savanna_grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 70,
  humidity_point = 15
})

PyuTest.register_overworld_biome("Forest", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_grass:dark_grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 60,

  _pyutest_biome_flowering = true
})

PyuTest.register_overworld_biome("MushroomFields", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_blocks:mycelium_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 30,
  humidity_point = 90,

  enable_beaches = false,
  _pyutest_fog_distance = 40,
})

PyuTest.register_overworld_biome("LargeMushroomForest", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_blocks:mycelium_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 30,
  humidity_point = 90,

  enable_beaches = false,
  _pyutest_fog_distance = 40,
})

PyuTest.register_overworld_biome("SnowyForest", PyuTest.BIOME_TYPES.COLD, {
  node_dust = "pyutest_blocks:snow_carpet",
  node_top = "pyutest_blocks:snow_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  node_water_top = "pyutest_blocks:ice_block",
  depth_water_top = 5,

  heat_point = 5,
  humidity_point = 60,
  _pyutest_fog_distance = 80,
})

PyuTest.register_overworld_biome("Taiga", PyuTest.BIOME_TYPES.CHILLY, {
  node_top = "pyutest_grass:dark_grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 20,
  humidity_point = 60,

  _pyutest_biome_flowering = true
})

PyuTest.register_overworld_biome("CherryGrove", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_grass:grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 70,

  _pyutest_biome_flowering = true,
  _pyutest_biome_flowering_extra = true
})


PyuTest.register_overworld_biome("BirchForest", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_grass:grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 60,

  _pyutest_biome_flowering = true
})

PyuTest.register_overworld_biome("OldGrowthBirchForest", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_grass:grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 60,

  _pyutest_biome_flowering = true,
  _pyutest_biome_flowering_extra = true
})

PyuTest.register_overworld_biome("AspenForest", PyuTest.BIOME_TYPES.CHILLY, {
  node_top = "pyutest_grass:aspen_grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 20,
  humidity_point = 50,

  _pyutest_biome_flowering = true,
  _pyutest_fog_distance = 40,
})

PyuTest.register_overworld_biome("RedwoodForest", PyuTest.BIOME_TYPES.CHILLY, {
  node_top = "pyutest_blocks:podzol_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 20,
  humidity_point = 50,

  _pyutest_biome_flowering = true,
  _pyutest_fog_distance = 40,
})

PyuTest.register_overworld_biome("Swamp", PyuTest.BIOME_TYPES.WETLAND, {
  node_top = "pyutest_grass:swampy_grass_block",
  node_filler = "pyutest_blocks:dirt_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.lowland,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 30,
  humidity_point = 80,

  enable_beaches = false,
  _pyutest_fog_distance = 40,
})

PyuTest.register_overworld_biome("IceSpikes", PyuTest.BIOME_TYPES.COLD, {
  node_top = "pyutest_blocks:ice_block",
  node_filler = "pyutest_blocks:ice_block",

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  node_water_top = "pyutest_blocks:ice_block",
  depth_water_top = 5,

  heat_point = 5,
  humidity_point = 60
})

PyuTest.register_overworld_biome("Meadow", PyuTest.BIOME_TYPES.NORMAL, {
  node_top = "pyutest_grass:dark_grass_block",
  node_filler = "pyutest_blocks:dirt_block",
  depth_filler = 4,

  y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
  y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

  heat_point = 50,
  humidity_point = 60,

  _pyutest_biome_flowering = true,
  _pyutest_biome_flowering_extra = true
})
