PyuTest.make_node("pyutest_blocks:crate", "Crate", {
  choppy = PyuTest.BLOCK_NORMAL
}, { "pyutest-crate.png" }, {
  on_construct = function(pos)
    local meta = core.get_meta(pos)
    local inventory = meta:get_inventory()
    inventory:set_size("main", 8 * 4)
  end,

  on_destruct = function(pos)
    local drops = {}
    PyuTest.get_inventory_drops(pos, "main", drops)

    for _, v in pairs(drops) do
      core.add_item(pos, v)
    end
  end,

  on_rightclick = function(pos, node, clicker)
    local spos = string.format("%d,%d,%d", pos.x, pos.y, pos.z)
    local formspec =
        "size[8,9]" ..
        "list[nodemeta:" .. spos .. ";main;0,0;8,4;]" ..
        "list[current_player;main;0,5;8,4;]" ..
        "listring[nodemeta:" .. spos .. ";main]" ..
        "listring[current_player;main]"
    core.show_formspec(clicker:get_player_name(), string.format("pyutest_blocks:crate_%d_%d_%d", pos.x, pos.y, pos.z),
      formspec)
    core.sound_play({ name = "crate_open", gain = 1 }, { pos = pos })
  end,
  _pyutest_blast_resistance = 2
})
