core.register_privilege("fun", {
  description = "Access to \"powerful\" fun commands",
  give_to_singeplayer = true
})

core.register_chatcommand("explode", {
  params = "<range>",
  description = "Create an explosion of size RANGE.",
  privs = {
    fun = true
  },
  func = function(name, param)
    local player = core.get_player_by_name(name)
    local range = tonumber(param)

    if range == nil then
      return false, "Please use a number for the range."
    end

    PyuTest.create_explosion(player:get_pos(), range, false, range, { player })
  end
})

core.register_chatcommand("rtp", {
  description = [[Teleport to a random location in the world.
  This command may or may not kill you.]],
  func = function(name)
    local player = core.get_player_by_name(name)

    local player_pos = player:get_pos()

    math.randomseed(os.time())
    local pos = vector.new(math.random(-31000, 31000), player_pos.y, math.random(-31000, 31000))
    player:set_pos(pos)
  end
})
