PyuTest.make_node("pyutest_farming:farmland", "Farmland", {
  ground = 1,
  acid_vulnerable = 1,
  crumbly = PyuTest.BLOCK_FAST
}, { "pyutest-farmland.png", "pyutest-dirt.png" }, {
  drop = "pyutest_blocks:dirt_block",
  drawtype = "nodebox",
  node_box = PyuTest.NODE_BOXES.SLIGHTLY_SMALLER
})

PyuTest.make_item("pyutest_farming:hoe", "Hoe", {
  tool = 1
}, "pyutest-hoe.png", {
  stack_max = 1,
  on_place = function(itemstack, user, pointed_thing)
    if pointed_thing.type == "node" then
      local pos = pointed_thing.under
      local node = core.get_node(pos)

      if core.get_item_group(node.name, "dirt") ~= 0 then
        core.set_node(pos, { name = "pyutest_farming:farmland" })
      end
    end
  end
})

PyuTest.make_crop = function(name, desc, output, growtime, water_multiplier, textures, grow_into)
  local t = textures or {}

  PyuTest.make_node(name .. "_crop", desc .. "Crop", {
    flammable = 1,
    dig_immediate = 3,
    attached_node = 3,
    oddly_breakable_by_hand = PyuTest.BLOCK_FAST,
    not_in_creative_inventory = 1
  }, { t["crop"] or "pyutest-crop.png" }, {
    drawtype = "plantlike",
    color = t["crop_color"],
    drop = name .. "_seeds",
    paramtype = "light",
    sunlight_propagates = true,
    walkable = false,
    floodable = true,
    on_construct = function(pos)
      local time = growtime

      if PyuTest.node_beside_group(pos - vector.new(0, 1, 0), "water") then
        time = time * (water_multiplier or 0.5)
      end

      local timer = core.get_node_timer(pos)
      timer:start(time)
    end,
    on_timer = function(pos)
      core.set_node(pos, { name = grow_into or name .. "_grown" })
    end,
    _pyutest_blast_resistance = 0
  })

  if not grow_into then
    PyuTest.make_node(name .. "_grown", desc .. " Crop", {
      flammable = 1,
      dig_immediate = 3,
      attached_node = 3,
      oddly_breakable_by_hand = PyuTest.BLOCK_FAST,
      not_in_creative_inventory = 1
    }, { t["grown"] or "pyutest-crop-grown.png" }, {
      drawtype = "plantlike",
      color = t["grown_color"],
      paramtype = "light",
      sunlight_propagates = true,
      walkable = false,
      floodable = true,
      drop = {
        max_items = 1,
        items = {
          {
            items = { ItemStack(name .. "_seeds 3"), ItemStack(output) }
          }
        }
      },
      _pyutest_blast_resistance = 0
    })
  end

  PyuTest.make_item(name .. "_seeds", desc .. " Seeds", { seeds = 1 }, t["seed"] or "pyutest-seeds.png", {
    color = t["seed_color"],
    on_place = function(itemstack, user, pointed_thing)
      if pointed_thing.type == "node" then
        local pos = pointed_thing.under
        local node = core.get_node(pos)

        if node.name == "pyutest_farming:farmland" then
          core.place_node(pointed_thing.under + vector.new(0, 1, 0), { name = name .. "_crop" }, user)
          itemstack:set_count(itemstack:get_count() - 1)
          return itemstack
        end
      end
    end
  })
end
