PyuTest.make_node("pyutest_blocks:sponge", "Sponge", {
  oddly_breakable_by_hand = PyuTest.BLOCK_FAST
}, { "pyutest-sponge.png" }, {
  _pyutest_blast_resistance = 0
})

PyuTest.make_node("pyutest_blocks:light", "Light", {
  light = 1,
  dig_immediate = 1,
  oddly_breakable_by_hand = PyuTest.BLOCK_FAST
}, {
  "pyutest-light.png"
}, {
  drawtype = "torchlike",
  walkable = false,
  paramtype = "light",
  sunlight_propagates = true,
  light_source = core.LIGHT_MAX,
  floodable = true,
  _pyutest_blast_resistance = 0
})

PyuTest.make_node("pyutest_blocks:torch", "Torch", {
  dig_immediate = 1,
  light = 1,
  attached_node = 1,
  emits_heat = 1,
  oddly_breakable_by_hand = PyuTest.BLOCK_FAST
}, {
  "pyutest-torch.png",
  "pyutest-torch.png^[transform6",
  "pyutest-torch.png^[transform1"
}, {
  light_source = core.LIGHT_MAX,
  walkable = false,
  drawtype = "torchlike",
  paramtype = "light",
  inventory_image = "pyutest-torch.png",
  paramtype2 = "wallmounted",
  floodable = true,
  _pyutest_blast_resistance = 0
})

PyuTest.make_node("pyutest_blocks:glass", "Glass", {
  cracky = PyuTest.BLOCK_FAST
}, { "pyutest-glass.png", "pyutest-glass-overlay.png" }, {
  drawtype = "glasslike_framed",
  paramtype = "light",
  sunlight_propagates = true,
})

-- FIXME: This has been in the game for months, implement it already!
PyuTest.make_node("pyutest_blocks:trapdoor", "Trapdoor", {
  choppy = PyuTest.BLOCK_NORMAL,
  flammable = 1
}, { "pyutest-trapdoor.png" }, {
  drawtype = "nodebox",
  paramtype = "light",
  sunlight_propagates = true,
  node_box = {
    type = "fixed",
    fixed = { -0.5, -0.5, -0.5, 0.5, -0.15, 0.5 }
  },
  _pyutest_blast_resistance = 2
})

PyuTest.make_node("pyutest_blocks:contagious_acid", "Contagious Acid", {
  crumbly = PyuTest.BLOCK_NORMAL,
  solid_node = 1
}, { "pyutest-acid.png" }, {
    _pyutest_blast_resistance = 0
})

PyuTest.make_node("pyutest_blocks:tnt", "TNT", {
  dig_immediate = 1,
  oddly_breakable_by_hand = PyuTest.BLOCK_FAST
}, {
  "pyutest-tnt-top-bottom.png",
  "pyutest-tnt-top-bottom.png",
  "pyutest-tnt-side.png" -- Affects all other sides
}, {
  on_rightclick = function(pos, node, clicker)
    core.after(3, function()
      if core.get_node(pos).name ~= "pyutest_blocks:tnt" then
        return
      end
      PyuTest.create_explosion(pos, 2, true, 12)
    end)
  end,

  __on_electricity_activated = function(pos, node, sender_pos)
    core.after(3, function()
      if core.get_node(pos).name ~= "pyutest_blocks:tnt" then
        return
      end
      PyuTest.create_explosion(pos, 3, true, 12)
    end)
  end,
  _pyutest_blast_resistance = 0
})

PyuTest.make_node("pyutest_blocks:workbench", "Workbench", {
  choppy = PyuTest.BLOCK_NORMAL
}, {
  "pyutest-workbench-top.png",
  "pyutest-workbench-bottom.png",
  "pyutest-workbench-sides.png"
}, {
  on_rightclick = function(pos, node, clicker)
    core.show_formspec(clicker:get_player_name(), "pyutest_blocks:workbench", table.concat({
      "size[8,7.5]",
      "list[current_player;craft;2.5,0;3,3;]",
      "list[current_player;craftpreview;6.5,1;1,1;]",
      "list[current_player;main;0,3.5;8,4;]"
    }))
  end,
  _pyutest_blast_resistance = 2
})

PyuTest.make_node("pyutest_blocks:ladder", "Ladder", {
  dig_immediate = 1,
  oddly_breakable_by_hand = PyuTest.BLOCK_FAST
}, { "pyutest-ladder.png" }, {
  drawtype = "signlike",
  paramtype = "light",
  walkable = false,
  climbable = true,
  buildable_to = true,
  sunlight_propagates = true,
  paramtype2 = "wallmounted",
  selection_box = {
    type = "wallmounted"
  },
  collision_box = {
    type = "wallmounted"
  },
  inventory_image = "pyutest-ladder.png",
  _pyutest_blast_resistance = 0
})

PyuTest.make_node("pyutest_blocks:magma", "Magma", {
  cracky = PyuTest.BLOCK_FAST,
  fire_persist = 1
}, { "pyutest-molten-rock.png" }, {
  paramtype = "light",
  light_source = 11,
  overlay_tiles = {
    { name = "pyutest-ore-overlay.png", color = "#c55623" }
  },
  on_walk_over = function(pos, node, player)
    if player then
      PyuTest.deal_damage(player, 3, PyuTest.DAMAGE_TYPES.burning())
    end
  end,
  _pyutest_blast_resistance = 2
})

PyuTest.make_node("pyutest_blocks:basalt_magma", "Basalt Magma", {
  cracky = PyuTest.BLOCK_FAST,
  fire_persist = 1
}, { "pyutest-basalt.png" }, {
  paramtype = "light",
  light_source = 11,
  overlay_tiles = {
    { name = "pyutest-ore-overlay.png", color = "#c55623" }
  },
  on_walk_over = function(pos, node, player)
    if player then
      PyuTest.deal_damage(player, 3, PyuTest.DAMAGE_TYPES.burning())
    end
  end,
  _pyutest_blast_resistance = 3
})

PyuTest.make_node("pyutest_blocks:bedrock", "Bedrock", {
}, { "pyutest-bedrock.png" }, {
  diggable = false,
  pointable = "blocking",
  is_ground_content = false,
  _pyutest_blast_resistance = 1000
})

PyuTest.make_node("pyutest_blocks:weak_ice", "Weak Ice", {
  cracky = PyuTest.BLOCK_FAST
}, { "pyutest-ice.png" }, {
  on_walk_over = function(pos)
    core.set_node(pos, { name = "pyutest_blocks:water_source" })
  end,
})

core.register_abm({
  label = "Sponge Loop",
  nodenames = { "pyutest_blocks:sponge" },
  neighbors = { "group:liquid" },
  interval = 0,
  chance = 1,
  action = function(pos)
    local range = 4

    local function replace(npos)
      local node = core.get_node(npos)
      if node.name == "air" then return end
      local def = core.registered_nodes[node.name]

      if def.groups["liquid"] == 1 then
        core.remove_node(npos)
      end
    end

    PyuTest.dorange(pos, range, function(p)
      replace(p)
    end)
  end
})

core.register_abm({
  label = "Contagious Acid Spread",
  nodenames = { "group:acid_vulnerable" },
  neighbors = { "pyutest_blocks:contagious_acid" },
  interval = 2.4,
  chance = 2.2,
  catchup = true,
  action = function(pos)
    if not core.settings:get_bool("acid_spreads", true) then
      return
    end

    core.set_node(pos, {
      name = "pyutest_blocks:contagious_acid"
    })
  end
})
