PyuTest = {}
Translate = function(s)
  return core.get_translator(core.get_current_modname())(s)
end

PyuTest.BLOCK_FAST = 3
PyuTest.BLOCK_NORMAL = 2
PyuTest.BLOCK_SLOW = 1

PyuTest.OVERWORLD_SURFACE_BOTTOM = 1
PyuTest.OVERWORLD_TOP = 4096
PyuTest.OVERWORLD_BOTTOM = -200
-- these values are yoinked from VoxeLibre
-- (https://git.minetest.land/VoxeLibre/VoxeLibre/src/branch/master/mods/MAPGEN/mcl_biomes/init.lua)
PyuTest.OVERWORLD_OCEAN_MIN = -15
PyuTest.OVERWORLD_DEEP_OCEAN_MAX = PyuTest.OVERWORLD_OCEAN_MIN - 1
PyuTest.OVERWORLD_DEEP_OCEAN_MIN = -31
PyuTest.CAVE_TOP = PyuTest.OVERWORLD_DEEP_OCEAN_MIN - 1
PyuTest.CAVE_BOTTOM = -50

PyuTest.WORLD_TOP = 31000
PyuTest.WORLD_BOTTOM = -31000

PyuTest.NODEBOX_DEFAULT = {
  type = "fixed",
  fixed = { -0.5, -0.5, -0.5, 0.5, 0.5, 0.5 },
}

PyuTest.DEFAULT_EFFECTS = {
  sky_type = "regular",
  sky_base_color = "#FFFFFF",
  fog_distance = -1,
  fog_start = -1,
  fog_color = "#00000000"
}

PyuTest.WORLD_GRAVITY = core.settings:get("movement_gravity")

PyuTest.get_schematic_path = function(name)
  return core.get_modpath("pyutest") .. "/schematics/" .. name .. ".mts"
end

local modpath = core.get_modpath("pyutest")
dofile(modpath .. "/damage.lua")
dofile(modpath .. "/util.lua")
