PyuTest.make_leaves = function(id, desc, color, overlay, special_drops, drops)
  local leaves_id = id .. "_leaves_block"
  PyuTest.make_node(leaves_id, desc .. " Leaves", {
    acid_vulnerable = 1,
    flammable = 1,
    snappy = PyuTest.BLOCK_FAST
  }, { { name = "pyutest-leaves.png", color = color } }, {
    drawtype = "allfaces_optional",
    waving = 2,
    paramtype = "light",
    sunlight_propagates = true,
    is_ground_content = false,
    overlay_tiles = { overlay },
    _pyutest_blast_resistance = 0
  })
  if special_drops == nil or special_drops == true then
    core.override_item(leaves_id, {
      drop = drops or {
        max_items = 1,
        items = {
          {
            tool_groups = {
              "shears"
            },
            items = { leaves_id }
          },

          {
            rarity = 2.2,
            items = { "pyutest_tools:apple" }
          },

          {
            rarity = 2.2,
            items = { "pyutest_tools:banana" }
          },

          {
            rarity = 2.2,
            items = { "pyutest_tools:stick 2" }
          },

          {
            rarity = 1.6,
            items = { "pyutest_tools:stick 1" }
          }
        }
      }
    })
  end
end

PyuTest.make_leaves("pyutest_leaves:oak", "Oak", "#749752")
PyuTest.make_leaves("pyutest_leaves:snowy", "Snowy")
PyuTest.make_leaves("pyutest_leaves:cherry", "Cherry", "#f3c2db")
PyuTest.make_leaves("pyutest_leaves:dark", "Dark", "#4f613e")
PyuTest.make_leaves("pyutest_leaves:aspen", "Aspen", "#978c52")
PyuTest.make_leaves("pyutest_leaves:red_aspen", "Red Aspen", "#945c53")
