PyuTest.registered_wood = {}
PyuTest.make_wood = function(id, desc, ltiles, btiles)
  PyuTest.make_building_blocks(id .. "_log", desc .. " Log", ltiles, nil, {
    choppy = PyuTest.BLOCK_NORMAL,
    acid_vulnerable = 1,
    flammable = 1,
    _pyutest_blast_resistance = 2
  }, {
    is_ground_content = false
  })

  PyuTest.make_building_blocks(id .. "_wood", desc .. " Planks", btiles, nil, {
    choppy = PyuTest.BLOCK_NORMAL,
    acid_vulnerable = 1,
    flammable = 1,
    _pyutest_blast_resistance = 2
  }, {
    is_ground_content = false
  })

  local log_id = id .. "_log_block"
  local planks_id = id .. "_wood_block"

  core.override_item(log_id, {
    groups = PyuTest.util.tableconcat(core.registered_nodes[log_id].groups, {
      wooden_log = 1,
      fuel = 1
    }),
    paramtype2 = "facedir",
    on_place = core.rotate_node
  })

  core.override_item(planks_id, {
    groups = PyuTest.util.tableconcat(core.registered_nodes[planks_id].groups, {
      wooden_planks = 1,
      fuel = 1
    })
  })

  core.register_craft({
    output = planks_id .. " 4",
    recipe = { log_id },
    type = "shapeless"
  })

  PyuTest.registered_wood[id] = {
    log = log_id,
    wood = planks_id
  }
end

PyuTest.make_wood("pyutest_wood:oak", "Oak", {
  "pyutest-log-top-bottom.png",
  "pyutest-log-top-bottom.png",
  "pyutest-log.png"
}, {
  "pyutest-wood.png"
})

PyuTest.make_wood("pyutest_wood:savanna", "Savanna", {
  "pyutest-savanna-log-top-bottom.png",
  "pyutest-savanna-log-top-bottom.png",
  "pyutest-savanna-log.png"
}, {
  "pyutest-savanna-wood.png"
})

PyuTest.make_wood("pyutest_wood:birch", "Birch", {
  "pyutest-birch-log-top-bottom.png",
  "pyutest-birch-log-top-bottom.png",
  "pyutest-birch-log.png"
}, {
  "pyutest-birch-wood.png"
})

PyuTest.make_wood("pyutest_wood:cherry", "Cherry", {
  "pyutest-cherry-log-top-bottom.png",
  "pyutest-cherry-log-top-bottom.png",
  "pyutest-cherry-log.png"
}, {
  "pyutest-cherry-wood.png"
})

PyuTest.make_wood("pyutest_wood:redwood", "Redwood", {
  "pyutest-redwood-log-top-bottom.png",
  "pyutest-redwood-log-top-bottom.png",
  "pyutest-redwood-log.png"
}, {
  "pyutest-redwood.png"
})

PyuTest.make_wood("pyutest_wood:jungle", "Jungle", {
  "pyutest-jungle-log-top-bottom.png",
  "pyutest-jungle-log-top-bottom.png",
  "pyutest-jungle-log.png"
}, {
  "pyutest-jungle-wood.png"
})
