PyuTest.electricity_activate = function(pos, sender_pos, sender)
	local node = core.get_node(pos)
	local def = core.registered_nodes[node.name]

	if def.__on_electricity_input then
		def.__on_electricity_input(pos, node, sender_pos, sender)
	end
end

PyuTest.component_after_place_node = function (pos)
	local meta = core.get_meta(pos)
	meta:set_string(PyuTest.WIRECUTTER_META_NAME, core.serialize({}))
end

PyuTest.component_action = function (pos, interacter)
	core.sound_play("pyutest_button", {
		pos = pos,
		gain = 0.35
	})

	local p = PyuTest.get_node_electricity_targets(pos)

	if p then
		for _, pp in pairs(p) do
			PyuTest.electricity_activate(pp, pos, interacter)
		end
	else
		core.chat_send_player(interacter:get_player_name(), "This component isn't bound to anything!")
	end
end

PyuTest.make_button = function(id, desc, groups, tiles)
	PyuTest.make_node(id, desc, PyuTest.util.tableconcat(groups, {
		electric = 1
	}), tiles, {
		is_ground_content = false,
		after_place_node = PyuTest.component_after_place_node,
		on_rightclick = function(pos, node, clicker)
			PyuTest.component_action(pos, clicker)
		end
	})
end

PyuTest.make_electricity_device = function(id, desc, groups, tiles, craftitem, opts, ifn)
	PyuTest.make_node(id, desc, PyuTest.util.tableconcat(groups, {
		electric = 1
	}), tiles, PyuTest.util.tableconcat(opts or {}, {
		__on_electricity_input = ifn,
	}))

	-- Dont create a recipe if it is nil
	if craftitem ~= nil then
		core.register_craft({
			output = id,
			recipe = {
				{ "group:cobble", "group:cobble", "group:cobble" },
				{ "group:cobble", craftitem,                    "group:cobble" },
				{ "group:cobble", "group:cobble", "group:cobble" }
			},
		})
	end
end
