local function get_items_from_group(name)
	local list = {}
	for k, v in pairs(core.registered_items) do
		if core.get_item_group(k, name) ~= 0 then
			table.insert(list, k)
		end
	end
	return list
end

-- Remove built-in Unified Inventory categories
for k, v in pairs(unified_inventory.registered_categories) do
	unified_inventory.remove_category(k)
end

unified_inventory.register_category("pyutest_inventory:blocks", {
	symbol = "pyutest_blocks:stone_block",
	label = "Blocks",
	index = 3,
	items = get_items_from_group("block")
})

unified_inventory.register_category("pyutest_inventory:tools", {
	symbol = "pyutest_tools:iron_pickaxe",
	label = "Tools",
	index = 4,
	items = get_items_from_group("tool")
})

unified_inventory.register_category("pyutest_inventory:furniture", {
	symbol = "pyutest_furniture:oak_wood_chair",
	label = "Furniture",
	index = 5,
	items = get_items_from_group("furniture")
})

unified_inventory.register_category("pyutest_inventory:minerals", {
	symbol = "pyutest_ores:diamond_ore",
	label = "Minerals",
	index = 6,
	items = get_items_from_group("mineral")
})

unified_inventory.register_category("pyutest_inventory:colored", {
	symbol = "pyutest_wool:red_wool_block",
	label = "Colored Items",
	index = 7,
	items = get_items_from_group("colored")
})

unified_inventory.register_category("pyutest_inventory:flowers", {
	symbol = "pyutest_flowers:rose",
	label = "Flora",
	index = 8,
	items = get_items_from_group("flower")
})

unified_inventory.register_category("pyutest_inventory:fuel", {
	symbol = "pyutest_ores:coal_lump",
	label = "Fuel",
	index = 9,
	items = get_items_from_group("fuel")
})


unified_inventory.register_category("pyutest_inventory:solid_nodes", {
	symbol = "pyutest_blocks:stone_block",
	label = "Solid Nodes",
	index = 10,
	items = get_items_from_group("solid")
})

unified_inventory.register_category("pyutest_inventory:electricity", {
	symbol = "pyutest_electricity:button",
	label = "Electricity",
	index = 11,
	items = get_items_from_group("electric")
})

unified_inventory.register_category("pyutest_inventory:food", {
	symbol = "pyutest_tools:apple",
	label = "Foodstuff",
	index = 12,
	items = get_items_from_group("food")
})
