-- "Just right"
PyuTest.register_overworld_biome("Plains", PyuTest.BIOME_TYPES.NORMAL, {
	node_top = "pyutest_blocks:grass",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 65,
	humidity_point = 40,

	weight = PyuTest.BIOME_WEIGHTS.large,

	_pyutest_biome_flowering = true,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.NORMAL,
})

PyuTest.register_overworld_biome("Forest", PyuTest.BIOME_TYPES.NORMAL, {
	node_top = "pyutest_blocks:grass",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 50,
	humidity_point = 80,

	weight = PyuTest.BIOME_WEIGHTS.big,

	_pyutest_biome_flowering = true,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.LUSH,
})

PyuTest.register_overworld_biome("BirchForest", PyuTest.BIOME_TYPES.NORMAL, {
	node_top = "pyutest_blocks:grass",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 50,
	humidity_point = 84,

	weight = PyuTest.BIOME_WEIGHTS.big,

	_pyutest_biome_flowering = true,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.NORMAL,
})

PyuTest.register_overworld_biome("OldGrowthBirchForest", PyuTest.BIOME_TYPES.NORMAL, {
	node_top = "pyutest_blocks:grass",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 50,
	humidity_point = 87,

	weight = PyuTest.BIOME_WEIGHTS.big,

	_pyutest_biome_flowering = true,
	_pyutest_biome_flowering_extra = true,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.NORMAL,
})

PyuTest.register_overworld_biome("Meadow", PyuTest.BIOME_TYPES.NORMAL, {
	node_top = "pyutest_blocks:grass",
	node_filler = "pyutest_blocks:dirt",
	depth_filler = 4,

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.elevated,
	y_min = PyuTest.OVERWORLD_BIOME_TOPS.normal,

	heat_point = 50,
	humidity_point = 83,

	weight = PyuTest.BIOME_WEIGHTS.big,

	_enable_beaches = false,
	_pyutest_biome_flowering = true,
	_pyutest_biome_flowering_extra = true,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.LUSH,
})

PyuTest.register_overworld_biome("CherryGrove", PyuTest.BIOME_TYPES.NORMAL, {
	node_top = "pyutest_blocks:grass",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.elevated,
	y_min = PyuTest.OVERWORLD_BIOME_TOPS.normal,

	heat_point = 50,
	humidity_point = 85,

	weight = PyuTest.BIOME_WEIGHTS.small,

	_enable_beaches = false,
	_pyutest_biome_flowering = true,
	_pyutest_biome_flowering_extra = true,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.NORMAL,
})

-- Warm, Hot
PyuTest.register_overworld_biome("Desert", PyuTest.BIOME_TYPES.HOT, {
	node_top = "pyutest_blocks:sand_block",
	node_filler = "pyutest_blocks:sandstone_block",
	depth_filler = 9,

	node_riverbed = "pyutest_blocks:sand_block",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.elevated,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 80,
	humidity_point = 0,

	weight = PyuTest.BIOME_WEIGHTS.vast,

	_enable_beaches = false,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.DRY,
})

PyuTest.register_overworld_biome("Savanna", PyuTest.BIOME_TYPES.WARM, {
	node_top = "pyutest_blocks:grass",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 75,
	humidity_point = 0,

	weight = PyuTest.BIOME_WEIGHTS.large,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.DRY,
})

-- Decent
PyuTest.register_overworld_biome("MushroomFields", PyuTest.BIOME_TYPES.NORMAL, {
	node_top = "pyutest_blocks:mycelium_block",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.lowland,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 50,
	humidity_point = 94,

	weight = PyuTest.BIOME_WEIGHTS.tiny,

	_enable_beaches = false,
	_pyutest_fog_distance = 60,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.SWAMP,
})

PyuTest.register_overworld_biome("LargeMushroomForest", PyuTest.BIOME_TYPES.NORMAL, {
	node_top = "pyutest_blocks:mycelium_block",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.lowland,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 50,
	humidity_point = 95,

	weight = PyuTest.BIOME_WEIGHTS.tiny,

	_enable_beaches = false,
	_pyutest_fog_distance = 60,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.SWAMP,
})

PyuTest.register_overworld_biome("Swamp", PyuTest.BIOME_TYPES.WETLAND, {
	node_top = "pyutest_blocks:grass",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.lowland,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 50,
	humidity_point = 100,

	weight = PyuTest.BIOME_WEIGHTS.tiny,

	_enable_beaches = false,
	_pyutest_fog_distance = 60,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.SWAMP,
})

-- Chilly
PyuTest.register_overworld_biome("Taiga", PyuTest.BIOME_TYPES.CHILLY, {
	node_top = "pyutest_blocks:grass",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 20,
	humidity_point = 72,

	weight = PyuTest.BIOME_WEIGHTS.normal,

	_pyutest_biome_flowering = true,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.DARK,
})

PyuTest.register_overworld_biome("OldGrowthPineTaiga", PyuTest.BIOME_TYPES.CHILLY, {
	node_top = "pyutest_blocks:podzol_block",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 26,
	humidity_point = 73,

	weight = PyuTest.BIOME_WEIGHTS.large,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.DARK,
})

PyuTest.register_overworld_biome("AspenForest", PyuTest.BIOME_TYPES.CHILLY, {
	node_top = "pyutest_blocks:grass",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 19,
	humidity_point = 74,

	weight = PyuTest.BIOME_WEIGHTS.small,

	_pyutest_biome_flowering = true,
	_pyutest_fog_distance = 60,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.ASPEN,
})

PyuTest.register_overworld_biome("RedwoodForest", PyuTest.BIOME_TYPES.CHILLY, {
	node_top = "pyutest_blocks:podzol_block",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 23,
	humidity_point = 76,

	weight = PyuTest.BIOME_WEIGHTS.small,

	_pyutest_biome_flowering = true,
	_pyutest_fog_distance = 60,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.DARK,
})

PyuTest.register_overworld_biome("OminousForest", PyuTest.BIOME_TYPES.CHILLY, {
	node_top = "pyutest_blocks:grass",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	heat_point = 19,
	humidity_point = 81,

	weight = PyuTest.BIOME_WEIGHTS.tiny,

	_pyutest_fog_distance = 45,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.MAGIC,
})

-- Winter
PyuTest.register_overworld_biome("FrozenPlains", PyuTest.BIOME_TYPES.COLD, {
	node_dust = "pyutest_blocks:snow_carpet",
	node_top = "pyutest_blocks:snow_block",
	node_filler = "pyutest_blocks:snow_block",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	node_water_top = "pyutest_blocks:ice_block",
	depth_water_top = 1,

	heat_point = 0,
	humidity_point = 73,

	weight = PyuTest.BIOME_WEIGHTS.large,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.SNOW,
})

PyuTest.register_overworld_biome("SnowyForest", PyuTest.BIOME_TYPES.COLD, {
	node_dust = "pyutest_blocks:snow_carpet",
	node_top = "pyutest_blocks:snow_block",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	node_water_top = "pyutest_blocks:ice_block",
	depth_water_top = 5,

	heat_point = 0,
	humidity_point = 78,

	weight = PyuTest.BIOME_WEIGHTS.large,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.SNOW,
})

PyuTest.register_overworld_biome("IceSpikes", PyuTest.BIOME_TYPES.COLD, {
	node_top = "pyutest_blocks:ice_block",
	node_filler = "pyutest_blocks:ice_block",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,

	node_water_top = "pyutest_blocks:ice_block",
	depth_water_top = 5,

	heat_point = 0,
	humidity_point = 75,

	weight = PyuTest.BIOME_WEIGHTS.large,

	_enable_beaches = false,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.SNOW,
})

-- Mountains
PyuTest.register_overworld_biome("StonyPeaks", PyuTest.BIOME_TYPES.CHILLY, {
	depth_top = 0,
	depth_filler = 0,

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.elevated,
	y_min = PyuTest.OVERWORLD_BIOME_TOPS.normal,

	heat_point = 20,
	humidity_point = 30,

	vertical_blend = 8,

	weight = PyuTest.BIOME_WEIGHTS.large,

	_enable_beaches = false,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.DRY,
})

PyuTest.register_overworld_biome("FrozenPeaks", PyuTest.BIOME_TYPES.COLD, {
	node_top = "pyutest_blocks:snow_block",
	node_filler = "pyutest_blocks:ice_block",
	depth_filler = 5,

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.elevated,
	y_min = PyuTest.OVERWORLD_BIOME_TOPS.normal,

	heat_point = 0,
	humidity_point = 76,

	vertical_blend = 8,

	weight = PyuTest.BIOME_WEIGHTS.large,

	_enable_beaches = false,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.SNOW,
})

PyuTest.register_overworld_biome("JaggedPeaks", PyuTest.BIOME_TYPES.COLD, {
	node_top = "pyutest_blocks:snow_block",
	depth_filler = 0,

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.elevated,
	y_min = PyuTest.OVERWORLD_BIOME_TOPS.normal,

	heat_point = 0,
	humidity_point = 79,

	vertical_blend = 8,

	weight = PyuTest.BIOME_WEIGHTS.large,

	_enable_beaches = false,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.SNOW,
})

PyuTest.register_overworld_biome("Grove", PyuTest.BIOME_TYPES.COLD, {
	node_top = "pyutest_blocks:snow_block",
	node_filler = "pyutest_blocks:dirt",

	y_max = PyuTest.OVERWORLD_BIOME_TOPS.elevated,
	y_min = PyuTest.OVERWORLD_BIOME_TOPS.normal,

	heat_point = 0,
	humidity_point = 73,

	vertical_blend = 8,

	weight = PyuTest.BIOME_WEIGHTS.large,

	_enable_beaches = false,
	_pyutest_foliage_index = PyuTest.FOLIAGE_TYPES.SNOW,
})
