PyuTest.make_upgrade_rune = function(name, desc, stat, increase, max, color, craftitem)
	PyuTest.make_item(name, desc, {
		upgrade_rune = 1,
	}, "pyutest-rune.png", {
		color = color,
		on_use = function(itemstack, user, pointed_thing)
			if not user then return end
			if not user:is_player() then return end

			local value = PyuTest.get_player_stat(user, stat)

			if value == max then
				return
			end

			-- Stat value below 1 causes problems
			if (value + increase) < 1 then
				return
			end

			PyuTest.set_player_stat(user, stat, value + increase)

			core.sound_play({ name = "pyutest_magic_action", gain = 0.75 }, { pos = user:get_pos() })
			itemstack:take_item()
			return itemstack
		end
	})

	if craftitem ~= nil then
		core.register_craft({
			output = name,
			recipe = {
				{ "",                           "pyutest_ores:emerald_shard", "" },
				{ "pyutest_ores:emerald_shard", craftitem,                    "pyutest_ores:emerald_shard" },
				{ "",                           "pyutest_ores:emerald_shard", "" },
			}
		})
	end
end

PyuTest.make_upgrade_rune("pyutest_upgrades:defense", "Defense Upgrade Rune", "defense", 0.5, 5, "green",
"pyutest_ores:diamond_shard")
PyuTest.make_upgrade_rune("pyutest_upgrades:attack", "Attack Upgrade Rune", "attack", 0.5, 3, "red",
"pyutest_ores:gold_ingot")
