local modpath = core.get_modpath(core.get_current_modname())

dofile(modpath .. "/stats.lua")

-- player setup
core.register_on_joinplayer(function(player)
	if player == nil then return end
	local name = player:get_player_name()

	player:get_inventory():set_width("main", 8)
	player:get_inventory():set_size("main", 8 * 4)
	player:hud_set_hotbar_itemcount(8)
	player:set_lighting({
		volumetric_light = { strength = 0.1 },
		saturation = 1.1,
		shadows = { intensity = 0.33 },
		exposure = {
			luminance_min = -3.5,
			luminance_max = -2.5,
			exposure_correction = 0.35,
			speed_dark_bright = 1500,
			speed_bright_dark = 700,
		},
	})

	-- creative mode privs
	if core.is_creative_enabled(name) then
		core.set_player_privs(name, PyuTest.util.tableconcat({
			fly = true,
			fast = true,
			creative = true,
		}, core.get_player_privs(name)))
	end
end)

-- player hand
core.register_item(":", {
	type = "none",
	description = "Hands",
	wield_image = "pyutest-hand.png",
	groups = {
		not_in_creative_inventory = 1
	}
})

PyuTest.HAND_TOOL_CAPS = PyuTest.tool_caps({
	uses = 0,
	attck_uses = 0,
	damage_groups = { fleshy = 2 },

	groupcaps = {
		oddly_breakable_by_hand = {
			times = {
				[PyuTest.BLOCK_FAST] = 0.35,
				[PyuTest.BLOCK_NORMAL] = 0.50,
				[PyuTest.BLOCK_SLOW] = 0.65,
			}
		},
		snappy = {
			times = {
				[PyuTest.BLOCK_FAST] = 0.55,
				[PyuTest.BLOCK_NORMAL] = 0.70,
				[PyuTest.BLOCK_SLOW] = 0.70
			}
		},
		crumbly = {
			times = {
				[PyuTest.BLOCK_FAST] = 0.75,
				[PyuTest.BLOCK_NORMAL] = 0.80,
				[PyuTest.BLOCK_SLOW] = 0.90
			}
		},
		choppy = {
			times = {
				[PyuTest.BLOCK_FAST] = 1.2,
				[PyuTest.BLOCK_NORMAL] = 2.3,
				[PyuTest.BLOCK_SLOW] = 2.9,
			}
		},
		cracky = {
			times = {
				[PyuTest.BLOCK_FAST] = 6,
				[PyuTest.BLOCK_NORMAL] = 10,
				[PyuTest.BLOCK_SLOW] = 45,
			}
		},
		wooly = {
			times = {
				[PyuTest.BLOCK_FAST] = 0.55,
				[PyuTest.BLOCK_NORMAL] = 0.70,
				[PyuTest.BLOCK_SLOW] = 0.70
			}
		},
	}
})

if core.is_creative_enabled("") then
	local caps = PyuTest.tool_caps({
		uses = 0,
		time = 0.25,

		groupcaps = {
			crumbly = {},
			choppy = {},
			cracky = {},
			snappy = {},
			wooly = {},
			oddly_breakable_by_hand = {},
			creative_breaking = {}
		},

		attack_uses = 0,
		damage_groups = { fleshy = 10000 }
	})

	core.override_item("", {
		range = 15,
		tool_capabilities = caps
	})
else
	core.override_item("", {
		range = 6,
		tool_capabilities = PyuTest.HAND_TOOL_CAPS
	})
end

-- unlimited blocks in creative mode
core.register_on_placenode(function(_, _, placer)
	if placer and placer:is_player() then
		return core.is_creative_enabled(placer:get_player_name())
	end
end)

-- player lighting, and sky effects for different biomes
core.register_globalstep(function()
	local players = core.get_connected_players()

	for _, player in pairs(players) do
		local pos = player:get_pos()
		local def = PyuTest.get_biome_def(pos)

		if def == nil then
			player:set_lighting(PyuTest.DEFAULT_EFFECTS.lighting)
			player:set_sky(PyuTest.DEFAULT_EFFECTS.sky)
			return
		end

		local sky_type = def._pyutest_sky_type or PyuTest.DEFAULT_EFFECTS.sky_type
		local sky_base_color = def._pyutest_sky_base_color or PyuTest.DEFAULT_EFFECTS.sky_base_color
		local fog_distance = def._pyutest_fog_distance or PyuTest.DEFAULT_EFFECTS.fog_distance
		local fog_start = def._pyutest_fog_start or PyuTest.DEFAULT_EFFECTS.fog_start
		local fog_color = def._pyutest_fog_color or PyuTest.DEFAULT_EFFECTS.fog_color

		player:set_sky({
			type = sky_type,
			base_color = sky_base_color,
			fog = {
				fog_distance = fog_distance,
				fog_start = fog_start,
				fog_color = fog_color
			}
		})
	end
end)
