-- Springs
core.register_ore({
	ore_type = "scatter",
	ore = "pyutest_blocks:water_source",
	wherein = PyuTest.ORE_STONES,
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 1,
	clust_size = 1,
	y_max = PyuTest.OVERWORLD_TOP,
	y_min = PyuTest.OVERWORLD_SURFACE_BOTTOM,
})

core.register_ore({
	ore_type = "scatter",
	ore = "pyutest_blocks:lava_source",
	wherein = PyuTest.ORE_STONES,
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 1,
	clust_size = 1,
	y_max = PyuTest.OVERWORLD_DEEP_OCEAN_MIN - 1,
	y_min = PyuTest.OVERWORLD_BOTTOM,
})

-- Mountain Strips
core.register_ore({
	ore_type = "sheet",
	ore = "pyutest_blocks:calcite_block",
	wherein = "pyutest_blocks:stone_block",
	y_max = PyuTest.OVERWORLD_BIOME_TOPS.highlands,
	y_min = PyuTest.OVERWORLD_BIOME_TOPS.normal,
	noise_params = PyuTest.MOUNTAIN_STRIP_NOISE_PARAMS,
	column_height_max = 18,
	column_height_min = 8,
	column_midpoint_factor = 1,
})

-- Pastures
core.register_decoration({
	deco_type = "schematic",
	place_on = {"group:grass"},
	sidelen = 16,
	fill_ratio = 0.0006,
	biomes = {"Plains"},
	schematic = PyuTest.generate_pasture_schematic(4, "pyutest_farming:pumpkin", 0),
	rotation = "random",
	flags = "place_center_x, place_center_z"
})

core.register_decoration({
	deco_type = "schematic",
	place_on = {"group:grass"},
	sidelen = 16,
	fill_ratio = 0.0006,
	biomes = {"Plains"},
	schematic = PyuTest.generate_pasture_schematic(4, "pyutest_blocks:haybale_block", 0),
	rotation = "random",
	flags = "place_center_x, place_center_z"
})

-- Boulders
core.register_decoration({
	deco_type = "schematic",
	place_on = {"group:grass", "group:dirt"},
	sidelen = 16,
	fill_ratio = 0.0019,
	biomes = {"OldGrowthPineTaiga", "RedwoodForest", "OminousForest"},
	schematic = PyuTest.generate_boulder_schematic(3, "pyutest_blocks:mossy_cobblestone_block"),
	rotation = "random",
	flags  = "place_center_x, place_center_z"
})
