PyuTest.make_tool("pyutest_tools:hand", "Hand Strength", {
	not_in_creative_inventory = 1,
}, "pyutest-hand.png", {
	stack_max = 1,
	tool_capabilities = PyuTest.HAND_TOOL_CAPS
})

PyuTest.make_tool("pyutest_tools:shears", "Shears", {
	shears = 1
}, "pyutest-shears.png", {
	stack_max = 1,
	tool_capabilities = PyuTest.tool_caps({
		uses = 100,
		attack_uses = 50,
		groupcaps = {
			snappy = {
				times = {
					[PyuTest.BLOCK_FAST] = 0.2,
					[PyuTest.BLOCK_NORMAL] = 0.3,
					[PyuTest.BLOCK_SLOW] = 0.4
				}
			},

			wooly = {
				times = {
					[PyuTest.BLOCK_FAST] = 0.2,
					[PyuTest.BLOCK_NORMAL] = 0.3,
					[PyuTest.BLOCK_SLOW] = 0.4
				}
			}
		}
	})
})

PyuTest.make_item("pyutest_tools:bomb", "Bomb", {}, "pyutest-bomb.png", {
	stack_max = 16,
	on_use = function(_, user)
		if user == nil then
			return
		end
		local pos = user:get_pos()
		PyuTest.create_explosion(pos, 1, false, 6, { user })
		local stack = user:get_wielded_item()
		stack:set_count(stack:get_count() - 1)

		user:set_wielded_item(stack)
	end
})

PyuTest.make_item("pyutest_tools:flint_and_steel", "Flint and Steel", {}, "pyutest-flint-and-steel.png", {
	stack_max = 1,
	on_place = function(itemstack, user, pointed_thing)
		if pointed_thing.type == "node" then
			core.set_node(pointed_thing.above, { name = "pyutest_blocks:fire" })

			core.sound_play({
				name = "pyutest_alt_place",
				gain = 1
			}, {
				pos = user:get_pos()
			})
		end
	end
})
