if true then -- replaced with Wuzzy's hudbars mod.
	return
end

core.hud_replace_builtin("health", {})
core.hud_replace_builtin("breath", {})

PyuTest.HUDBARS = {
	defs = {},
	defs_count = 0,
	players = {}
}
PyuTest.Hudbar = {}
local HudbarMeta = { __index = PyuTest.Hudbar, __newindex = PyuTest.Hudbar }

core.register_on_joinplayer(function(player)
	local key = player:get_player_name()
	PyuTest.HUDBARS.players[key] = PyuTest.HUDBARS.players[key] or {}
	for k, v in pairs(PyuTest.HUDBARS.defs) do
		local ref = PyuTest.HUDBARS.players[key]

		ref[k] = {idx = player:hud_add(v.cfg), name = k}
	end

	core.register_globalstep(function(dtime)
		for _, v in pairs(PyuTest.HUDBARS.players[key]) do
			PyuTest.HUDBARS.defs[v.name].update(v.idx, player)
		end
	end)
end)

function PyuTest.Hudbar:add(name, def, update)
	local cfg = def or {}
	cfg.hud_elem_type = "statbar"
	cfg.position = {x = 0.5, y = 0.925}
	cfg.direction = 0
	cfg.size = {x = 24, y = 24}
	cfg.offset = {
		x = (-10 * 24 - 25) * -(PyuTest.HUDBARS.defs_count - 1),
		y = (-48 + 24 + 16)
	}
	cfg.text2 = cfg.text2 or "pyutest-bar-empty.png"

	local m = setmetatable({
		cfg = cfg,
		update = update or function()end
	}, HudbarMeta)

	PyuTest.HUDBARS.defs[name] = m
	PyuTest.HUDBARS.defs_count = PyuTest.HUDBARS.defs_count + 1
end


local enable_damage = core.settings:get_bool("enable_damage")

if enable_damage then
	PyuTest.Hudbar:add("health", {
		text = "pyutest-heart.png",
		text2 = "pyutest-heart-empty.png",
		number = core.PLAYER_MAX_HP_DEFAULT,
		item = core.PLAYER_MAX_HP_DEFAULT,
	}, function (idx, player)
		player:hud_change(idx, "number", player:get_hp())
	end)

	PyuTest.Hudbar:add("breath", {
		text = "pyutest-bubble.png",
		text2 = "pyutest-bubble-empty.png",
		number = core.PLAYER_MAX_BREATH_DEFAULT,
		item = core.PLAYER_MAX_BREATH_DEFAULT,
	}, function (idx, player)
		player:hud_change(idx, "number", player:get_breath())
	end)
end
