PyuTest.NODE_BOXES = {
	CARPET = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, -0.45, 0.5 }
	},
	SLAB = {
		type = "fixed",
		fixed = { -0.5, -0.5, -0.5, 0.5, 0, 0.5 }
	},
	PILLAR = {
		type = "fixed",
		fixed = { -0.15, -0.5, -0.15, 0.15, 0.5, 0.15 }
	},
	STAIRS = {
		type = "fixed",
		fixed = {
			{ -0.5, -0.5, -0.5, 0.5, 0,   0.5 },
			{ -0.5, 0,    0,    0.5, 0.5, 0.5 },
		},
	},
	SLIGHTLY_SMALLER = {
		type = "fixed",
		fixed = {
			{ -0.5, -0.5, -0.5, 0.5, 0.45, 0.5 },
		}
	},
	SMALL = {
		type = "fixed",
		fixed = {-0.35, -0.5, -0.35, 0.35, 0.5, 0.35}
	}
}

PyuTest.make_node_sounds = function(tbl)
	local t = tbl or {}
	t.footstep = t.footstep or { name = "pyutest_block_walk", gain = 1 }
	t.dig = t.dig or { name = "pyutest_block_dig", gain = 0.50 }
	t.dug = t.dug or { name = "pyutest_block_break", gain = 0.50 }
	t.place = t.place or { name = "pyutest_block_place", gain = 0.70 }
	return t
end

local modpath = core.get_modpath("pyutest_blocks")

dofile(modpath .. "/api/fences.lua")
dofile(modpath .. "/api/stairs.lua")
dofile(modpath .. "/api/doors.lua")
dofile(modpath .. "/api/signs.lua")

PyuTest.make_node = function(name, desc, groups, tiles, extra_conf)
	local conf = {
		description = Translate(desc),
		tiles = tiles,
		groups = groups
	}
	conf["sounds"] = PyuTest.make_node_sounds()

	if extra_conf ~= nil then
		for k, v in pairs(extra_conf) do
			conf[k] = v
		end

		conf["sounds"] = PyuTest.make_node_sounds(extra_conf.sounds)
	end

	core.register_node(name, conf)
end

PyuTest.building_blocks = {}
PyuTest.make_building_blocks = function(name, desc, tex, colortint, cgroups, extra_conf)
	local groups = PyuTest.util.tablecopy(cgroups) or {}
	groups["block"] = 1

	local econf = extra_conf or {}
	econf["is_ground_content"] = econf["is_ground_content"] or true
	econf["color"] = colortint

	local id_block = name .. "_block"
	local id_carpet = name .. "_carpet"
	local id_slab = name .. "_slab"
	local id_pillar = name .. "_pillar"
	local id_stairs = name .. "_stairs"
	local id_fence = name .. "_fence"
	local id_door = name .. "_door"
	local id_sign = name .. "_sign"

	core.register_alias(id_block, name)

	local split = name:split(":")
	table.insert(PyuTest.building_blocks, {
		ns = split[#split - 1],
		name = split[#split],
		desc = desc,
		tiles = tex,
		groups = groups,
		econf = econf
	})

	core.register_node(name, PyuTest.util.tableconcat({
		description = Translate(desc),
		tiles = tex,
		groups = PyuTest.util.tableconcat(groups, {
			solid = 1
		}),
		sounds = PyuTest.make_node_sounds(),
	}, econf))

	core.register_node(id_carpet, PyuTest.util.tableconcat({
		description = Translate(desc .. " Carpet"),
		tiles = tex,
		groups = PyuTest.util.tableconcat(PyuTest.util.tablecopy(groups), {
			attached_node = 1
		}),
		drawtype = "nodebox",
		paramtype = "light",
		paramtype2 = "colorfacedir",
		node_box = PyuTest.NODE_BOXES.CARPET,
		sounds = PyuTest.make_node_sounds(),
		buildable_to = true,
		floodable = true
	}, econf))

	core.register_node(id_pillar, PyuTest.util.tableconcat({
		description = Translate(desc .. " Pillar"),
		tiles = tex,
		groups = groups,
		drawtype = "nodebox",
		paramtype = "light",
		node_box = PyuTest.NODE_BOXES.PILLAR,
		sounds = PyuTest.make_node_sounds()
	}, econf))

	PyuTest.make_slab(id_slab, desc .. " Slab", id_block, tex, groups, econf)
	PyuTest.make_stairs(id_stairs, desc .. " Stairs", id_block, tex, groups, econf)

	PyuTest.make_fence(id_fence, desc .. " Fence", id_block, tex, groups, econf)
	PyuTest.make_door(id_door, desc .. " Door", id_block, tex, groups, econf)
	PyuTest.make_sign(id_sign, desc .. " Sign", id_block, tex, groups, econf)

	core.register_craft({
		output = id_carpet .. " 2",
		recipe = {
			{ id_block, id_block }
		}
	})

	core.register_craft({
		output = id_pillar .. " 3",
		recipe = {
			{ id_block },
			{ id_block },
			{ id_block }
		}
	})
end

PyuTest.make_liquid = function(name, desc, groups, texture, speed, extra_conf)
	local function make_liquid_flags(liquidtype)
		local drawtype = ""

		if liquidtype == "source" then
			drawtype = "liquid"
		elseif liquidtype == "flowing" then
			drawtype = "flowingliquid"
		end

		local t = PyuTest.util.tableconcat({
			drawtype = drawtype,
			waving = 3,
			walkable = false,
			pointable = false,
			buildable_to = true,
			is_ground_content = false,
			use_texture_alpha = "blend",
			paramtype = "light",
			drop = "",
			drowning = 4,
			liquidtype = liquidtype,
			liquid_renewable = true,
			liquid_viscosity = speed or 1,
			liquid_alternative_flowing = name .. "_flowing",
			liquid_alternative_source = name .. "_source",
			paramtype2 = liquidtype == "flowing" and "flowingliquid" or nil,
			special_tiles = liquidtype == "flowing" and {
				{
					name = texture,
					backface_culling = false
				},
				{
					name = texture,
					backface_culling = true
				}
			} or nil,
			_pyutest_blast_resistance = 1000
		}, extra_conf or {})
		return t
	end

	local g = groups or {}
	g["liquid"] = 1
	g["not_in_creative_inventory"] = 1

	PyuTest.make_node(name .. "_source", desc .. " Source", PyuTest.util.tableconcat(g, {
		liquid_source = 1
	}), { texture }, make_liquid_flags("source"))
	PyuTest.make_node(name .. "_flowing", "Flowing " .. desc, g, { texture }, make_liquid_flags("flowing"))
	PyuTest.make_node(name .. "_infinite", "Infinite " .. desc, PyuTest.util.tableconcat(g, {
		not_in_creative_inventory = 0
	}), { texture }, PyuTest.util.tableconcat(make_liquid_flags("source"), {
		liquid_alternative_source = name .. "_infinite",
		liquid_alternative_flowing = name .. "_infinite",
	}))
end
