local function formspec(pos)
	local meta = core.get_meta(pos)

	local t = {
		"field[settext;Set Text;${text}]"
	}

	return table.concat(t)
end

local function after_place_node(pos, placer)
	local meta = core.get_meta(pos)
	meta:set_string("text", "Edit text.")
	meta:set_string("infotext", "Edit text.")
	meta:set_string("formspec", formspec(pos))
end

local function on_receive_fields(pos, formname, fields, player)
	if fields.settext then
		local text = fields.settext
		local meta = core.get_meta(pos)
		meta:set_string("text", text)
		meta:set_string("infotext", text)
	end
end

PyuTest.make_sign = function (name, desc, craftitem, texture, groups, extra)
	core.register_node(name, PyuTest.util.tableconcat({
		description = Translate(desc),
		paramtype = "light",
		paramtype2 = "facedir",
		walkable = false,

		drawtype = "mesh",
		mesh = "pyutest-sign.obj",
		sounds = PyuTest.make_node_sounds(),

		groups = PyuTest.util.tableconcat(groups, {
			block = 0,
			sign = 1,
			attached_node = 3,
		}),
		tiles = texture,

		after_place_node = after_place_node,
		on_receive_fields = on_receive_fields,
	}, extra or {}))

	if craftitem ~= nil then
		core.register_craft({
			output = name .. " 3",
			recipe = {
				{craftitem, craftitem, craftitem},
				{craftitem, craftitem, craftitem},
				{"", "group:stick", ""},
			}
		})
	end
end
