PyuTest.make_tool("pyutest_magic:enchanted_pickaxe", "Enchanted Pickaxe", {
	pickaxe = 1
}, "pyutest-enchanted-pickaxe.png", {
	stack_max = 1,
	tool_capabilities = PyuTest.tool_caps({
		uses = 2768,
		attack_uses = 2768 / 2,
		groupcaps = {
			cracky = {
				times = {
					[PyuTest.BLOCK_FAST] = 0.1,
					[PyuTest.BLOCK_NORMAL] = 0.2,
					[PyuTest.BLOCK_SLOW] = 0.4
				}
			},

			crumbly = {
				times = {
					[PyuTest.BLOCK_FAST] = 0.2,
					[PyuTest.BLOCK_NORMAL] = 0.2,
					[PyuTest.BLOCK_SLOW] = 0.4,
				}
			}
		}
	}),
})

core.register_craft({
	output = "pyutest_magic:enchanted_pickaxe",
	recipe = {
		{ "pyutest_magic:enchanted_shard", "pyutest_magic:enchanted_shard", "pyutest_magic:enchanted_shard" },
		{ "",                              "group:stick",           "" },
		{ "",                              "group:stick",           "" }
	}
})

PyuTest.make_tool("pyutest_magic:enchanted_axe", "Enchanted Axe", {
	axe = 1
}, "pyutest-enchanted-axe.png", {
	stack_max = 1,
	tool_capabilities = PyuTest.tool_caps({
		uses = 2768,
		attack_uses = 2768,
		damage_groups = { fleshy = 10 },
		groupcaps = {
			choppy = {
				times = {
					[PyuTest.BLOCK_FAST] = 0.1,
					[PyuTest.BLOCK_NORMAL] = 0.2,
					[PyuTest.BLOCK_SLOW] = 0.4
				}
			}
		}
	})
})

core.register_craft({
	output = "pyutest_magic:enchanted_axe",
	recipe = {
		{ "pyutest_magic:enchanted_shard", "pyutest_magic:enchanted_shard", "" },
		{ "pyutest_magic:enchanted_shard", "group:stick",           "" },
		{ "",                              "group:stick",           "" }
	}
})

PyuTest.make_sword("pyutest_magic:enchanted_sword", "Enchanted Sword", "pyutest-enchanted-sword.png", 9, 3600, 0.7)

core.register_craft({
	output = "pyutest_magic:enchanted_sword",
	recipe = {
		{ "pyutest_magic:enchanted_shard" },
		{ "pyutest_magic:enchanted_shard" },
		{ "group:stick" }
	}
})


PyuTest.make_item("pyutest_magic:windball", "Windball", {}, "pyutest-windball.png", {
	stack_max = 16,
	on_use = function(_, user)
		if user == nil then
			return
		end

		local pos = user:get_pos()
		core.sound_play({ name = "pyutest_magic_action", gain = 0.75 }, { pos = pos })

		local vel = user:get_velocity()

		user:add_velocity({
			x = vel.x * 2.5,
			z = vel.z * 2.5,
			y = math.random(11, 14)
		})

		local stack = user:get_wielded_item()
		stack:set_count(stack:get_count() - 1)

		user:set_wielded_item(stack)
	end
})
